/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jaxrs.io.operations;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.nuxeo.ecm.automation.jaxrs.io.operations.ExecutionRequest;
import org.nuxeo.ecm.automation.jaxrs.io.operations.JsonRequestReader;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.webengine.jaxrs.context.RequestContext;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionFactory;

@Provider
@Consumes(value={"application/x-www-form-urlencoded"})
public class UrlEncodedFormRequestReader
implements MessageBodyReader<ExecutionRequest> {
    @Context
    protected HttpServletRequest request;
    @Context
    JsonFactory factory;

    public CoreSession getCoreSession() {
        return SessionFactory.getSession((HttpServletRequest)this.request);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MediaType.APPLICATION_FORM_URLENCODED_TYPE.equals((Object)mediaType) && ExecutionRequest.class.isAssignableFrom(type);
    }

    public ExecutionRequest readFrom(Class<ExecutionRequest> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String content = IOUtils.toString((InputStream)entityStream, (String)"UTF-8");
        String jsonString = null;
        if (content == null || content.isEmpty()) {
            jsonString = RequestContext.getActiveContext().getRequest().getParameter("jsondata");
        } else if (content.startsWith("jsondata=")) {
            jsonString = content.substring(9);
            jsonString = URLDecoder.decode(jsonString, "UTF-8");
        } else {
            return null;
        }
        if (jsonString == null) {
            return null;
        }
        JsonParser jp = this.factory.createJsonParser(jsonString);
        try {
            return JsonRequestReader.readRequest(jp, httpHeaders, this.getCoreSession());
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }
}

