/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.seam.operations;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.jsf.OperationHelper;
import org.nuxeo.ecm.automation.seam.operations.SeamOperationFilter;

@Operation(id="Seam.RunOperation", category="User Interface", label="Run operation in Seam Context", description="Initialize a Seam context (including Conversation if needed) and runs an Operation")
public class RunOperationInSeam {
    public static final String ID = "Seam.RunOperation";
    @Context
    protected OperationContext ctx;
    @Param(name="conversationId", required=false)
    protected String conversationId;
    @Context
    protected AutomationService service;
    @Param(name="id")
    protected String chainId;
    @Param(name="isolate", required=false, values={"false"})
    protected boolean isolate = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OperationMethod
    public Object run() throws Exception {
        HashMap<String, Object> vars = this.isolate ? new HashMap(this.ctx.getVars()) : this.ctx.getVars();
        OperationContext subctx = new OperationContext(this.ctx.getCoreSession(), vars);
        subctx.setInput(this.ctx.getInput());
        if (!OperationHelper.isSeamContextAvailable()) {
            SeamOperationFilter.handleBeforeRun(this.ctx, this.conversationId);
            try {
                Object object = this.runChain(subctx, vars);
                return object;
            }
            finally {
                SeamOperationFilter.handleAfterRun(this.ctx, this.conversationId);
            }
        }
        return this.runChain(subctx, vars);
    }

    protected Object runChain(OperationContext subctx, Map<String, Object> vars) throws Exception {
        if (this.chainId.startsWith("Chain.")) {
            return this.service.run(subctx, this.chainId.substring(6));
        }
        OperationChain chain = new OperationChain("operation");
        OperationParameters oparams = new OperationParameters(this.chainId, vars);
        chain.add(oparams);
        return this.service.run(subctx, chain);
    }
}

