/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.seam.operations;

import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.ServletLifecycle;
import org.jboss.seam.core.ConversationPropagation;
import org.jboss.seam.core.Manager;
import org.jboss.seam.web.ServletContexts;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.jsf.OperationHelper;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.actions.seam.SeamActionContext;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.SeamContextHelper;

public class SeamOperationFilter {
    protected static final Log log = LogFactory.getLog(SeamOperationFilter.class);

    public static void handleBeforeRun(OperationContext context, String conversationId) {
        CoreSession session = context.getCoreSession();
        if (!OperationHelper.isSeamContextAvailable()) {
            try {
                SeamOperationFilter.initializeSeamContext(context, conversationId, session);
            }
            catch (ClientException e) {
                log.error((Object)e.getMessage());
                return;
            }
        } else {
            SeamOperationFilter.setSeamActionContext(context, session);
        }
    }

    public static void handleAfterRun(OperationContext context, String conversationId) {
        if (!OperationHelper.isSeamContextAvailable()) {
            log.error((Object)"Cannot destroy Seam context: it is not initialized");
            return;
        }
        HttpServletRequest request = SeamOperationFilter.getRequest(context);
        if (request == null) {
            log.error((Object)"Can not destroy Seam context: no HttpServletRequest was found");
            return;
        }
        if (conversationId == null) {
            conversationId = (String)context.get((Object)"conversationId");
        }
        if (conversationId != null) {
            Contexts.getEventContext().remove("documentManager");
        }
        ServletLifecycle.endRequest((HttpServletRequest)request);
    }

    protected static void initializeSeamContext(OperationContext context, String conversationId, CoreSession session) throws ClientException {
        HttpServletRequest request = SeamOperationFilter.getRequest(context);
        if (request == null) {
            throw new ClientException("Can not init Seam context: no HttpServletRequest was found");
        }
        ServletLifecycle.beginRequest((HttpServletRequest)request);
        ServletContexts.instance().setRequest(request);
        if (conversationId == null) {
            conversationId = (String)context.get((Object)"conversationId");
        }
        if (conversationId != null) {
            ConversationPropagation.instance().setConversationId(conversationId);
            Manager.instance().restoreConversation();
            ServletLifecycle.resumeConversation((HttpServletRequest)request);
            Contexts.getEventContext().set("documentManager", (Object)session);
            SeamOperationFilter.setSeamActionContext(context, session);
        }
    }

    protected static HttpServletRequest getRequest(OperationContext context) {
        FacesContext faces;
        HttpServletRequest request = (HttpServletRequest)context.get((Object)"request");
        if (request == null && (faces = FacesContext.getCurrentInstance()) != null) {
            request = (HttpServletRequest)faces.getExternalContext().getRequest();
        }
        return request;
    }

    protected static void setSeamActionContext(OperationContext context, CoreSession session) {
        SeamActionContext seamActionContext = new SeamActionContext();
        NavigationContext navigationContext = (NavigationContext)Contexts.getConversationContext().get("navigationContext");
        seamActionContext.setCurrentDocument(navigationContext.getCurrentDocument());
        seamActionContext.setDocumentManager(session);
        seamActionContext.putLocalVariable("SeamContext", (Object)new SeamContextHelper());
        seamActionContext.setCurrentPrincipal((NuxeoPrincipal)session.getPrincipal());
        context.put("seamActionContext", (Object)seamActionContext);
    }
}

