/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.io.marshallers;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.server.jaxrs.io.JsonMarshaller;

public class DateMarshaller
implements JsonMarshaller<Date> {
    protected static final String TYPE = "date";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Class<Date> getJavaType() {
        return Date.class;
    }

    protected SimpleDateFormat newFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
    }

    @Override
    public Date resolveReference(String ref) {
        try {
            return this.newFormat().parse(ref);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("bad date format " + ref, e);
        }
    }

    @Override
    public String newReference(Date value) {
        return this.newFormat().format(value);
    }

    @Override
    public Date read(JSONObject json) {
        String data = (String)json.get(TYPE);
        try {
            return this.newFormat().parse(data);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("bad date format " + data, e);
        }
    }

    @Override
    public void write(JSONObject json, Object date) {
        String data = this.newFormat().format(date);
        json.put((Object)TYPE, (Object)data);
    }
}

