/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.internet.MimeMultipart;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.automation.server.jaxrs.ExceptionHandler;
import org.nuxeo.ecm.automation.server.jaxrs.ExecutionRequest;
import org.nuxeo.ecm.automation.server.jaxrs.io.InputStreamDataSource;
import org.nuxeo.ecm.automation.server.jaxrs.io.JsonRequestReader;
import org.nuxeo.ecm.automation.server.jaxrs.io.SharedFileInputStream;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.webengine.jaxrs.context.RequestCleanupHandler;
import org.nuxeo.ecm.webengine.jaxrs.context.RequestContext;

@Provider
@Consumes(value={"multipart/related"})
public class MultiPartRequestReader
implements MessageBodyReader<ExecutionRequest> {
    private static final Log log = LogFactory.getLog(MultiPartRequestReader.class);
    @Context
    protected HttpServletRequest request;

    public boolean isReadable(Class<?> arg0, Type arg1, Annotation[] arg2, MediaType arg3) {
        return ExecutionRequest.class.isAssignableFrom(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionRequest readFrom(Class<ExecutionRequest> arg0, Type arg1, Annotation[] arg2, MediaType arg3, MultivaluedMap<String, String> headers, InputStream in) throws IOException, WebApplicationException {
        ExecutionRequest req;
        block9: {
            req = null;
            try {
                List ctypes = (List)headers.get((Object)"Content-Type");
                String ctype = (String)ctypes.get(0);
                File tmp = File.createTempFile("nx-automation-mp-upload-", ".tmp");
                FileUtils.copyToFile((InputStream)in, (File)tmp);
                in = new SharedFileInputStream(tmp);
                try {
                    MimeMultipart mp = new MimeMultipart((DataSource)new InputStreamDataSource(in, ctype));
                    BodyPart part = mp.getBodyPart(0);
                    InputStream pin = part.getInputStream();
                    req = JsonRequestReader.readRequest(pin, headers);
                    int cnt = mp.getCount();
                    if (cnt == 2) {
                        req.setInput(MultiPartRequestReader.readBlob(this.request, mp.getBodyPart(1)));
                        break block9;
                    }
                    if (cnt > 2) {
                        BlobList blobs = new BlobList();
                        for (int i = 1; i < cnt; ++i) {
                            blobs.add((Object)MultiPartRequestReader.readBlob(this.request, mp.getBodyPart(i)));
                        }
                        req.setInput(blobs);
                        break block9;
                    }
                    log.error((Object)"Not all parts received.");
                    for (int i = 0; i < cnt; ++i) {
                        log.error((Object)("Received parts: " + mp.getBodyPart(i).getHeader("Content-ID")[0] + " -> " + mp.getBodyPart(i).getContentType()));
                    }
                    throw ExceptionHandler.newException(new IllegalStateException("Received only " + cnt + " part in a multipart request"));
                }
                finally {
                    tmp.delete();
                }
            }
            catch (Throwable e) {
                throw ExceptionHandler.newException("Failed to parse multipart request", e);
            }
        }
        return req;
    }

    public static Blob readBlob(HttpServletRequest request, BodyPart part) throws Exception {
        String ctype = part.getContentType();
        String fname = part.getFileName();
        InputStream pin = part.getInputStream();
        final File tmp = File.createTempFile("nx-automation-upload-", ".tmp");
        FileUtils.copyToFile((InputStream)pin, (File)tmp);
        FileBlob blob = new FileBlob(tmp, ctype, null, fname, null);
        RequestContext.getActiveContext((ServletRequest)request).addRequestCleanupHandler(new RequestCleanupHandler(){

            public void cleanup(HttpServletRequest req) {
                tmp.delete();
            }
        });
        return blob;
    }
}

