/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.automation.server.jaxrs.RestOperationContext;
import org.nuxeo.ecm.core.api.CoreSession;

public class ExecutionRequest {
    protected Object input;
    protected RestOperationContext ctx = new RestOperationContext();
    protected Map<String, Object> params;

    public ExecutionRequest() {
        this(null);
    }

    public ExecutionRequest(Object input) {
        this.input = input;
        this.params = new HashMap<String, Object>();
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public Object getInput() {
        return this.input;
    }

    public void setContextParam(String key, Object value) {
        this.ctx.put(key, value);
    }

    public void setContextParam(String key, String value) {
        this.ctx.put(key, value);
    }

    public void setParam(String key, Object jsonObject) {
        this.params.put(key, jsonObject);
    }

    public void setParam(String key, String value) {
        if (value.startsWith("expr:")) {
            if ((value = value.substring(5).trim()).contains("@{")) {
                this.params.put(key, Scripting.newTemplate((String)value));
            } else {
                this.params.put(key, Scripting.newExpression((String)value));
            }
        } else {
            this.params.put(key, value);
        }
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public OperationContext createContext(HttpServletRequest request, CoreSession session) throws Exception {
        this.ctx.addRequestCleanupHandler(request);
        this.ctx.setCoreSession(session);
        this.ctx.setInput(this.input);
        this.ctx.put("request", request);
        return this.ctx;
    }

    public OperationChain createChain(OperationType op) {
        OperationChain chain = new OperationChain("operation");
        OperationParameters oparams = new OperationParameters(op.getId(), this.params);
        chain.add(oparams);
        return chain;
    }
}

