/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.core.Context;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.server.AutomationServer;
import org.nuxeo.ecm.automation.server.jaxrs.ExceptionHandler;
import org.nuxeo.ecm.automation.server.jaxrs.ExecutionRequest;
import org.nuxeo.ecm.automation.server.jaxrs.ResponseHelper;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionFactory;
import org.nuxeo.runtime.api.Framework;

public abstract class ExecutableResource {
    @Context
    protected HttpServletRequest request;
    protected AutomationService service;

    protected ExecutableResource(AutomationService service) {
        this.service = service;
    }

    public CoreSession getCoreSession() {
        return SessionFactory.getSession((HttpServletRequest)this.request);
    }

    @POST
    public Object doPost(@Context HttpServletRequest request, ExecutionRequest xreq) {
        this.request = request;
        try {
            AutomationServer srv = (AutomationServer)Framework.getLocalService(AutomationServer.class);
            if (!srv.accept(this.getId(), this.isChain(), request)) {
                return ResponseHelper.notFound();
            }
            Object result = this.execute(xreq);
            return ResponseHelper.getResponse(result, request);
        }
        catch (Throwable e) {
            throw ExceptionHandler.newException("Failed to execute operation: " + this.getId(), e);
        }
    }

    public abstract String getId();

    public abstract Object execute(ExecutionRequest var1) throws Exception;

    public abstract boolean isChain();
}

