/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.batch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;

public class Batch {
    protected Map<String, Blob> uploadedBlob = new ConcurrentHashMap<String, Blob>();
    protected final String id;
    protected final String baseDir;

    public Batch(String id) {
        this.id = id;
        this.baseDir = new Path(System.getProperty("java.io.tmpdir")).append(id).toString();
        new File(this.baseDir).mkdirs();
    }

    public void addBlob(String idx, Blob blob) {
        this.uploadedBlob.put(idx, blob);
    }

    public void addStream(String idx, InputStream is, String name, String mime) throws IOException {
        File tmp = new File(new Path(this.baseDir).append(name).toString());
        FileUtils.copyToFile((InputStream)is, (File)tmp);
        FileBlob blob = new FileBlob(tmp);
        if (mime != null) {
            blob.setMimeType(mime);
        } else {
            blob.setMimeType("application/octetstream");
        }
        blob.setFilename(name);
        this.addBlob(idx, (Blob)blob);
    }

    public List<Blob> getBlobs() {
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        ArrayList<String> sortedIdx = new ArrayList<String>(this.uploadedBlob.keySet());
        Collections.sort(sortedIdx);
        for (String k : sortedIdx) {
            blobs.add(this.uploadedBlob.get(k));
        }
        return blobs;
    }

    public Blob getBlob(String fileId) {
        return this.uploadedBlob.get(fileId);
    }

    public void clear() {
        this.uploadedBlob.clear();
        FileUtils.deleteTree((File)new File(this.baseDir));
    }
}

