/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.ConflictOperationException;
import org.nuxeo.ecm.automation.InvalidOperationException;
import org.nuxeo.ecm.automation.OperationNotFoundException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;

public class ExceptionHandler {
    protected static final Log log = LogFactory.getLog(ExceptionHandler.class);
    protected int status = 500;
    protected String type;
    protected Throwable cause;
    protected String message;

    public static WebApplicationException newException(Throwable cause) {
        return ExceptionHandler.newException(null, cause);
    }

    public static WebApplicationException newException(String message, Throwable cause) {
        if (cause == null) {
            throw new IllegalArgumentException("the cause parameter cannot be null");
        }
        ExceptionHandler e = new ExceptionHandler(message, cause);
        return new WebApplicationException(cause, Response.status((int)e.getStatus()).entity((Object)e).build());
    }

    public static void abort(String message, Throwable cause) throws WebApplicationException {
        throw ExceptionHandler.newException(message, cause);
    }

    public static void abort(Throwable cause) throws WebApplicationException {
        throw ExceptionHandler.newException(null, cause);
    }

    public static int getStatus(Throwable cause) {
        return ExceptionHandler.getStatus(cause, 8);
    }

    public static boolean isSecurityError(Throwable t) {
        return ExceptionHandler.getStatus(t) == 401;
    }

    public static int getStatus(Throwable cause, int depth) {
        if (depth == 0) {
            log.warn((Object)"Possible infinite loop! Check the exception wrapping.");
            return 500;
        }
        if (cause instanceof DocumentSecurityException || cause instanceof SecurityException || "javax.ejb.EJBAccessException".equals(cause.getClass().getName())) {
            return 403;
        }
        if (cause instanceof NoSuchDocumentException) {
            return 404;
        }
        if (cause instanceof OperationNotFoundException) {
            return 404;
        }
        if (cause instanceof ConflictOperationException) {
            return 409;
        }
        if (cause instanceof InvalidOperationException) {
            return 400;
        }
        Throwable parent = cause.getCause();
        if (parent == cause) {
            log.warn((Object)"Infinite loop detected! Check the exception wrapping.");
            return 500;
        }
        if (parent != null) {
            return ExceptionHandler.getStatus(parent, depth - 1);
        }
        if (cause.getMessage() != null && cause.getMessage().contains("org.nuxeo.ecm.core.model.NoSuchDocumentException")) {
            log.warn((Object)"Badly wrapped exception: found a NoSuchDocumentException message but no NoSuchDocumentException", cause);
            return 404;
        }
        if (cause instanceof ClientException) {
            return 400;
        }
        return 500;
    }

    public ExceptionHandler(String message, Throwable cause) {
        if (cause == null) {
            throw new IllegalArgumentException("the cause parameter cannot be null");
        }
        this.status = ExceptionHandler.getStatus(cause);
        this.cause = cause;
        this.message = message == null ? cause.getMessage() : message;
        this.type = cause.getClass().getName();
    }

    public int getStatus() {
        return this.status;
    }

    public String getType() {
        return this.cause.getClass().getName();
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSerializedStackTrace() {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        this.cause.printStackTrace(pw);
        pw.flush();
        return writer.toString();
    }

    public Throwable getCause() {
        return this.cause;
    }
}

