/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.jackson.JsonFactory;
import org.nuxeo.ecm.automation.io.services.JsonFactoryManager;
import org.nuxeo.ecm.automation.server.AutomationServer;
import org.nuxeo.ecm.automation.server.RestBinding;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class AutomationServerComponent
extends DefaultComponent
implements AutomationServer {
    @Deprecated
    public static AutomationServerComponent me;
    protected static final String XP_BINDINGS = "bindings";
    protected Map<String, RestBinding> bindings;
    protected volatile Map<String, RestBinding> lookup;

    public void activate(ComponentContext context) throws Exception {
        this.bindings = new HashMap<String, RestBinding>();
        me = this;
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.bindings = null;
        me = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (XP_BINDINGS.equals(extensionPoint)) {
            RestBinding binding = (RestBinding)contribution;
            this.addBinding(binding);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (XP_BINDINGS.equals(extensionPoint)) {
            RestBinding binding = (RestBinding)contribution;
            this.removeBinding(binding);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (AutomationServer.class.isAssignableFrom(adapter)) {
            return adapter.cast(this);
        }
        return null;
    }

    public void applicationStarted(ComponentContext context) throws Exception {
        super.applicationStarted(context);
    }

    @Deprecated
    public JsonFactory getFactory() {
        return ((JsonFactoryManager)Framework.getLocalService(JsonFactoryManager.class)).getJsonFactory();
    }

    @Override
    public RestBinding getOperationBinding(String name) {
        return this.lookup().get(name);
    }

    @Override
    public RestBinding getChainBinding(String name) {
        return this.lookup().get("Chain." + name);
    }

    @Override
    public RestBinding[] getBindings() {
        Map<String, RestBinding> map = this.lookup();
        return map.values().toArray(new RestBinding[map.size()]);
    }

    protected String getBindingKey(RestBinding binding) {
        return binding.isChain() ? "Chain." + binding.getName() : binding.getName();
    }

    @Override
    public synchronized void addBinding(RestBinding binding) {
        String key = this.getBindingKey(binding);
        this.bindings.put(key, binding);
        this.lookup = null;
    }

    @Override
    public synchronized RestBinding removeBinding(RestBinding binding) {
        RestBinding result = this.bindings.remove(this.getBindingKey(binding));
        this.lookup = null;
        return result;
    }

    @Override
    public boolean accept(String name, boolean isChain, HttpServletRequest req) {
        RestBinding binding;
        if (isChain) {
            name = "Chain." + name;
        }
        if ((binding = this.lookup().get(name)) != null) {
            if (binding.isDisabled()) {
                return false;
            }
            if (binding.isSecure() && !req.isSecure()) {
                return false;
            }
            Principal principal = req.getUserPrincipal();
            if (binding.isAdministrator() || binding.hasGroups()) {
                if (principal instanceof NuxeoPrincipal) {
                    NuxeoPrincipal np = (NuxeoPrincipal)principal;
                    if (binding.isAdministrator() && np.isAdministrator()) {
                        return true;
                    }
                    if (binding.hasGroups()) {
                        for (String group : binding.getGroups()) {
                            if (!np.isMemberOf(group)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, RestBinding> lookup() {
        Map<String, RestBinding> _lookup = this.lookup;
        if (_lookup == null) {
            AutomationServerComponent automationServerComponent = this;
            synchronized (automationServerComponent) {
                _lookup = this.lookup = new HashMap<String, RestBinding>(this.bindings);
            }
        }
        return _lookup;
    }
}

