/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs;

import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;

@WebObject(type="bulk")
public class BulkDocumentsObject
extends DefaultObject {
    protected DocumentModelList docs;

    public <A> A getAdapter(Class<A> adapter) {
        if (adapter == DocumentModel.class) {
            return adapter.cast(this.docs);
        }
        return (A)super.getAdapter(adapter);
    }

    public void initialize(Object ... args) {
        assert (args != null && args.length == 1);
        this.docs = (DocumentModelList)args[0];
    }

    @GET
    public DocumentModelList doGet() {
        return this.docs;
    }

    @DELETE
    public Response doDelete() throws ClientException {
        CoreSession session = this.getContext().getCoreSession();
        for (DocumentModel doc : this.docs) {
            session.removeDocument(doc.getRef());
        }
        return Response.ok().build();
    }

    @PUT
    public DocumentModelList doUpdate(DocumentModel updateDoc) throws ClientException {
        CoreSession session = this.getContext().getCoreSession();
        for (DocumentModel doc : this.docs) {
            this.updateDirtyFields(updateDoc, doc);
            session.saveDocument(doc);
        }
        session.save();
        return this.docs;
    }

    private void updateDirtyFields(DocumentModel srcDoc, DocumentModel dstDoc) throws ClientException {
        for (Map.Entry entry : srcDoc.getDataModels().entrySet()) {
            String schemaName = (String)entry.getKey();
            for (String field : ((DataModel)entry.getValue()).getDirtyFields()) {
                Object value = srcDoc.getDataModel(schemaName).getValue(field);
                dstDoc.getDataModel(schemaName).setValue(field, value);
            }
        }
    }
}

