/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.adapters;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.nuxeo.ecm.automation.core.operations.business.adapter.BusinessAdapter;
import org.nuxeo.ecm.automation.io.services.codec.ObjectCodec;
import org.nuxeo.ecm.automation.io.services.codec.ObjectCodecService;
import org.nuxeo.ecm.automation.jaxrs.DefaultJsonAdapter;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.rest.DocumentObject;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;
import org.nuxeo.runtime.api.Framework;

@WebAdapter(name="bo", type="BOService", targetType="Document")
@Produces(value={"application/json+nxentity", "application/json"})
public class BOAdapter
extends DefaultAdapter {
    public static final String NAME = "bo";

    @GET
    @Path(value="{adapterName}")
    public Object doGetAdapter(@PathParam(value="adapterName") String adapterName) throws Exception {
        BusinessAdapter adapter = this.getAdapter(adapterName);
        return new DefaultJsonAdapter((Object)adapter);
    }

    @PUT
    @Path(value="{adapterName}")
    @Consumes(value={"application/json+nxentity", "application/json"})
    public Object doPostAdapter(@PathParam(value="adapterName") String adapterName, BusinessAdapter input) throws Exception {
        this.ctx.getCoreSession().saveDocument(input.getDocument());
        this.ctx.getCoreSession().save();
        return new DefaultJsonAdapter((Object)input);
    }

    @POST
    @Path(value="{adapterName}/{docName}")
    public Object doPutAdapter(@PathParam(value="adapterName") String adapterName, @PathParam(value="docName") String docName, BusinessAdapter input) throws Exception {
        DocumentModel document = input.getDocument();
        DocumentObject dobj = (DocumentObject)this.getTarget();
        DocumentModel parentDoc = dobj.getDocument();
        document.setPathInfo(parentDoc.getPathAsString(), docName);
        CoreSession session = this.ctx.getCoreSession();
        document = session.createDocument(document);
        session.save();
        BusinessAdapter adapter = (BusinessAdapter)document.getAdapter(input.getClass());
        return new DefaultJsonAdapter((Object)adapter);
    }

    private BusinessAdapter getAdapter(String adapterName) {
        ObjectCodecService cs = (ObjectCodecService)Framework.getLocalService(ObjectCodecService.class);
        ObjectCodec codec = cs.getCodec(adapterName);
        if (codec != null) {
            DocumentObject dobj = (DocumentObject)this.getTarget();
            DocumentModel doc = dobj.getDocument();
            return (BusinessAdapter)doc.getAdapter(codec.getJavaType());
        }
        throw new WebException(String.format("Unable to find [%s] adapter", adapterName));
    }
}

