/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.adapters;

import java.io.Serializable;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLBlob;
import org.nuxeo.ecm.platform.web.common.ServletHelper;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultAdapter;

@WebAdapter(name="blob", type="blob")
public class BlobAdapter
extends DefaultAdapter {
    public static final String NAME = "blob";
    protected String xpath;
    protected DocumentModel doc;

    protected void initialize(Object ... args) {
        super.initialize(args);
        if (args.length == 2) {
            this.xpath = (String)args[0];
            this.doc = (DocumentModel)args[1];
        }
    }

    @Path(value="{xpath}")
    public Resource doGet(@PathParam(value="xpath") String xpath) {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        return this.newObject(NAME, new Object[]{xpath, doc});
    }

    public <A> A getAdapter(Class<A> adapter) {
        if (adapter.isAssignableFrom(Blob.class)) {
            try {
                return adapter.cast(this.blob(this.xpath));
            }
            catch (ClientException e) {
                throw WebException.wrap((String)("Could not find any uploaded blob: " + this.xpath), (Throwable)e);
            }
        }
        return (A)super.getAdapter(adapter);
    }

    protected Blob blob(String xpath) throws ClientException {
        return (Blob)this.doc.getPropertyValue(xpath);
    }

    @GET
    public Response doGet(@Context Request request) throws ClientException {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        FormData form = this.ctx.getForm();
        String xpath = form.getString("property");
        if (doc.hasSchema("file")) {
            xpath = "file:content";
        }
        try {
            Response.ResponseBuilder builder;
            Property p = doc.getProperty(xpath);
            Blob blob = (Blob)p.getValue();
            if (blob == null) {
                throw new WebResourceNotFoundException("No attached file at " + xpath);
            }
            String fileName = blob.getFilename();
            if (fileName == null && (p = p.getParent()).isComplex()) {
                try {
                    fileName = (String)((Object)p.getValue("filename"));
                }
                catch (PropertyException e) {
                    fileName = "Unknown";
                }
            }
            EntityTag etag = null;
            if (blob instanceof SQLBlob) {
                etag = new EntityTag(((SQLBlob)blob).getBinary().getDigest());
            }
            if (etag != null && (builder = request.evaluatePreconditions(etag)) != null) {
                return builder.build();
            }
            String contentDisposition = ServletHelper.getRFC2231ContentDisposition((HttpServletRequest)this.ctx.getRequest(), (String)fileName);
            Response.ResponseBuilder builder2 = Response.ok((Object)blob).header("Content-Disposition", (Object)contentDisposition).type(blob.getMimeType());
            if (etag != null) {
                builder2.tag(etag);
            }
            return builder2.build();
        }
        catch (Exception e) {
            throw WebException.wrap((String)"Failed to get the attached file", (Throwable)e);
        }
    }

    @POST
    public Response doPost() {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        FormData form = this.ctx.getForm();
        form.fillDocument(doc);
        Blob blob = form.getFirstBlob();
        if (blob == null) {
            throw new IllegalArgumentException("Could not find any uploaded file");
        }
        try {
            Property p = doc.getProperty(this.xpath);
            if (p.isList()) {
                if ("files".equals(p.getSchema().getName())) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("filename", blob.getFilename());
                    map.put("file", (Serializable)blob);
                    p.addValue(map);
                } else {
                    p.addValue((Object)blob);
                }
            } else {
                if ("file".equals(p.getSchema().getName())) {
                    p.getParent().get("filename").setValue((Object)blob.getFilename());
                }
                p.setValue((Object)blob);
            }
            doc.putContextData("VersioningOption", (Serializable)form.getVersioningOption());
            CoreSession session = this.ctx.getCoreSession();
            session.saveDocument(doc);
            session.save();
            return this.redirect(this.getTarget().getPath());
        }
        catch (WebException e) {
            throw e;
        }
        catch (Exception e) {
            throw WebException.wrap((String)"Failed to attach file", (Throwable)e);
        }
    }

    @DELETE
    public Response doDelete() {
        DocumentModel doc = (DocumentModel)this.getTarget().getAdapter(DocumentModel.class);
        try {
            doc.getProperty(this.xpath).remove();
            CoreSession session = this.ctx.getCoreSession();
            session.saveDocument(doc);
            session.save();
        }
        catch (PropertyException e) {
            throw WebException.wrap((String)("Failed to delete attached file into property: " + this.xpath), (Throwable)e);
        }
        catch (ClientException e) {
            throw WebException.wrap((String)("Failed to delete attached file into property: " + this.xpath), (Throwable)e);
        }
        return this.redirect(this.getTarget().getPath());
    }
}

