/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.usermanager;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractUMObject<T>
extends DefaultObject {
    protected T currentArtifact;
    protected UserManager um;

    protected void initialize(Object ... args) {
        if (args.length < 1) {
            throw new IllegalArgumentException("UserObject takes at least one parameter");
        }
        this.um = (UserManager)Framework.getLocalService(UserManager.class);
        this.currentArtifact = args[0];
    }

    @GET
    public T doGetArtifact() {
        return this.currentArtifact;
    }

    @PUT
    public T doUpdateArtifact(T principal) {
        try {
            this.checkUpdateGuardPreconditions();
            return this.updateArtifact(principal);
        }
        catch (ClientException e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @DELETE
    public Response doDeleteArtifact() {
        try {
            this.checkUpdateGuardPreconditions();
            this.deleteArtifact();
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (ClientException e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    protected void checkUpdateGuardPreconditions() throws ClientException {
        NuxeoPrincipal principal = (NuxeoPrincipal)this.getContext().getCoreSession().getPrincipal();
        if (!(principal.isAdministrator() || principal.isMemberOf("powerusers") && this.isAPowerUserEditableArtifact())) {
            throw new WebSecurityException("User is not allowed to edit users");
        }
    }

    protected abstract boolean isAPowerUserEditableArtifact();

    protected abstract T updateArtifact(T var1) throws ClientException;

    protected abstract void deleteArtifact() throws ClientException;
}

