/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.usermanager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractUMRootObject<T>
extends DefaultObject {
    protected UserManager um;

    protected void initialize(Object ... args) {
        this.um = (UserManager)Framework.getLocalService(UserManager.class);
    }

    @Path(value="{artName}")
    public Object getArtifactWebObject(@PathParam(value="artName") String artName) {
        try {
            T artifact = this.getArtifact(artName);
            if (artifact == null) {
                throw new WebResourceNotFoundException(this.getArtifactType() + " does not exist");
            }
            return this.newObject(this.getArtifactType(), new Object[]{artifact});
        }
        catch (ClientException e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @POST
    public Response createNew(T artifact) {
        try {
            this.checkPrecondition(artifact);
            artifact = this.createArtifact(artifact);
            return Response.status((Response.Status)Response.Status.CREATED).entity(artifact).build();
        }
        catch (ClientException e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @GET
    @Path(value="search")
    public Response search(@QueryParam(value="q") String query) throws NoSuchMethodException, SecurityException, IllegalAccessException, InvocationTargetException {
        Method method = ((Object)((Object)this)).getClass().getDeclaredMethod("searchArtifact", String.class);
        GenericEntity entity = new GenericEntity(method.invoke((Object)this, query), method.getGenericReturnType());
        return Response.ok((Object)entity).build();
    }

    protected abstract List<T> searchArtifact(String var1) throws ClientException;

    protected abstract T getArtifact(String var1) throws ClientException;

    protected abstract String getArtifactType();

    protected abstract void checkPrecondition(T var1) throws ClientException;

    protected abstract T createArtifact(T var1) throws ClientException;

    protected void checkCurrentUserCanCreateArtifact(T artifact) {
        NuxeoPrincipal currentUser = (NuxeoPrincipal)this.getContext().getCoreSession().getPrincipal();
        if (!(currentUser.isAdministrator() || currentUser.isMemberOf("powerusers") && this.isAPowerUserEditableArtifact(artifact))) {
            throw new WebSecurityException("Cannot create artifact");
        }
    }

    abstract boolean isAPowerUserEditableArtifact(T var1);
}

