/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.usermanager;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.automation.server.jaxrs.usermanager.AbstractUMRootObject;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="users")
@Produces(value={"application/json", "application/json+nxentity"})
public class UserRootObject
extends AbstractUMRootObject<NuxeoPrincipal> {
    @Override
    protected NuxeoPrincipal getArtifact(String id) throws ClientException {
        return this.um.getPrincipal(id);
    }

    @Override
    protected String getArtifactType() {
        return "user";
    }

    @Override
    protected void checkPrecondition(NuxeoPrincipal principal) throws ClientException {
        this.checkCurrentUserCanCreateArtifact(principal);
        this.checkPrincipalDoesNotAlreadyExists(principal, this.um);
        this.checkPrincipalHasAName(principal);
    }

    @Override
    protected NuxeoPrincipal createArtifact(NuxeoPrincipal principal) throws ClientException {
        this.um.createUser(principal.getModel());
        return this.um.getPrincipal(principal.getName());
    }

    private void checkPrincipalDoesNotAlreadyExists(NuxeoPrincipal principal, UserManager um) throws ClientException {
        NuxeoPrincipal user = um.getPrincipal(principal.getName());
        if (user != null) {
            throw new WebException("User already exists", Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
    }

    private void checkPrincipalHasAName(NuxeoPrincipal principal) {
        if (principal.getName() == null) {
            throw new WebException("User MUST have a name", Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
    }

    @Override
    boolean isAPowerUserEditableArtifact(NuxeoPrincipal artifact) {
        return UserRootObject.isAPowerUserEditableUser(artifact);
    }

    static boolean isAPowerUserEditableUser(NuxeoPrincipal user) {
        UserManager um = (UserManager)Framework.getLocalService(UserManager.class);
        List adminGroups = um.getAdministratorsGroups();
        for (String adminGroup : adminGroups) {
            if (!user.getAllGroups().contains(adminGroup)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected List<NuxeoPrincipal> searchArtifact(String query) throws ClientException {
        DocumentModelList searchUsers = this.um.searchUsers(query);
        ArrayList<NuxeoPrincipal> users = new ArrayList<NuxeoPrincipal>(searchUsers.size());
        for (DocumentModel userDoc : searchUsers) {
            NuxeoPrincipal principal = this.um.getPrincipal((String)userDoc.getProperty(this.um.getUserIdField()).getValue(String.class));
            users.add(principal);
        }
        return users;
    }
}

