/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.test;

import com.google.inject.Binder;
import com.google.inject.Scopes;
import java.io.IOException;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.jaxrs.impl.HttpAutomationClient;
import org.nuxeo.ecm.automation.test.AutomationServerFeature;
import org.nuxeo.ecm.core.test.DetectThreadDeadlocksFeature;
import org.nuxeo.ecm.webengine.test.WebEngineFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.SimpleFeature;

@Features(value={DetectThreadDeadlocksFeature.class, WebEngineFeature.class, AutomationServerFeature.class})
@DetectThreadDeadlocksFeature.Config(dumpAtTearDown=true)
public class EmbeddedAutomationServerFeature
extends SimpleFeature {
    protected static final int HTTP_CONNECTION_TIMEOUT = 60000;
    protected HttpAutomationClient client;
    protected Session session;

    public void afterRun(FeaturesRunner runner) throws Exception {
        if (this.client != null) {
            this.client.shutdown();
            this.client = null;
            this.session = null;
        }
        super.afterRun(runner);
    }

    public void configure(FeaturesRunner runner, Binder binder) {
        super.configure(runner, binder);
        binder.bind(HttpAutomationClient.class).toProvider(() -> {
            if (this.client == null) {
                this.client = this.getHttpAutomationClient();
            }
            return this.client;
        }).in(Scopes.SINGLETON);
        binder.bind(Session.class).toProvider(() -> {
            if (this.client == null) {
                this.client = this.getHttpAutomationClient();
            }
            if (this.session == null) {
                try {
                    this.session = this.client.getSession("Administrator", "Administrator");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.session;
        }).in(Scopes.SINGLETON);
    }

    protected HttpAutomationClient getHttpAutomationClient() {
        HttpAutomationClient client = new HttpAutomationClient("http://localhost:18080/automation", 60000);
        client.setSharedRegistryExpirationDelay(0L);
        return client;
    }
}

