/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.test;

import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.jaxrs.impl.HttpAutomationClient;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.SimpleFeature;

public class RemoteAutomationServerFeature
extends SimpleFeature {
    protected static final Log log = LogFactory.getLog(RemoteAutomationServerFeature.class);
    protected static final String TEST_AUTOMATION_URL = "TEST_AUTOMATION_URL";
    protected HttpAutomationClient client;
    protected Session session;
    protected String automationUrl = System.getenv("TEST_AUTOMATION_URL");

    public RemoteAutomationServerFeature() {
        if (this.automationUrl == null) {
            this.automationUrl = "http://localhost:8080/nuxeo/site/automation";
            log.info((Object)("Could not find TEST_AUTOMATION_URL environment variable: fallback to: " + this.automationUrl));
        } else {
            log.info((Object)("Testing against: " + this.automationUrl));
        }
    }

    public void afterRun(FeaturesRunner runner) throws Exception {
        if (this.client != null) {
            this.client.shutdown();
            this.client = null;
            this.session = null;
        }
        super.afterRun(runner);
    }

    public void configure(FeaturesRunner runner, Binder binder) {
        super.configure(runner, binder);
        binder.bind(HttpAutomationClient.class).toProvider((Provider)new Provider<HttpAutomationClient>(){

            public HttpAutomationClient get() {
                if (RemoteAutomationServerFeature.this.client == null) {
                    RemoteAutomationServerFeature.this.client = new HttpAutomationClient(RemoteAutomationServerFeature.this.automationUrl);
                }
                return RemoteAutomationServerFeature.this.client;
            }
        }).in(Scopes.SINGLETON);
        binder.bind(Session.class).toProvider((Provider)new Provider<Session>(){

            public Session get() {
                if (RemoteAutomationServerFeature.this.client == null) {
                    RemoteAutomationServerFeature.this.client = new HttpAutomationClient(RemoteAutomationServerFeature.this.automationUrl);
                }
                if (RemoteAutomationServerFeature.this.session == null) {
                    RemoteAutomationServerFeature.this.session = RemoteAutomationServerFeature.this.client.getSession("Administrator", "Administrator");
                }
                return RemoteAutomationServerFeature.this.session;
            }
        }).in(Scopes.SINGLETON);
    }
}

