/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.context;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.context.ContextService;
import org.nuxeo.ecm.automation.core.context.DummyHelper;
import org.nuxeo.ecm.automation.features.PlatformFunctions;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class})
@Deploy(value={"org.nuxeo.ecm.automation.core", "org.nuxeo.ecm.automation.features"})
@LocalDeploy(value={"org.nuxeo.ecm.automation.test:helpers-contrib-test.xml"})
public class TestContextHelpers {
    @Inject
    CoreSession session;
    @Inject
    AutomationService automationService;

    @Test
    public void shouldGetContextService() {
        ContextService contextService = (ContextService)Framework.getService(ContextService.class);
        Assert.assertNotNull((Object)contextService);
    }

    @Test
    public void shouldGetBuiltInExtension() {
        ContextService contextService = (ContextService)Framework.getService(ContextService.class);
        Map contextHelperList = contextService.getHelperFunctions();
        Assert.assertTrue((boolean)contextHelperList.containsKey("Fn"));
        Assert.assertNotNull(contextHelperList.get("Fn"));
        Assert.assertTrue((boolean)(contextHelperList.get("Fn") instanceof PlatformFunctions));
    }

    @Test
    public void shouldUseNewExtension() throws OperationException {
        ContextService contextService = (ContextService)Framework.getService(ContextService.class);
        Map contextHelperList = contextService.getHelperFunctions();
        Assert.assertTrue((boolean)contextHelperList.containsKey("dummy"));
        Assert.assertNotNull(contextHelperList.get("dummy"));
        Assert.assertTrue((boolean)(contextHelperList.get("dummy") instanceof DummyHelper));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("script", "Context.dummy = dummy.helper1();");
        OperationContext ctx = new OperationContext();
        this.automationService.run(ctx, "RunScript", params);
        Assert.assertEquals((Object)"hello", (Object)ctx.get((Object)"dummy"));
    }
}

