/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.context;

import java.io.IOException;
import java.util.HashMap;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.test.EmbeddedAutomationServerFeature;
import org.nuxeo.ecm.automation.test.repository.AutomationRepositoryInit;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.Jetty;

@RunWith(value=FeaturesRunner.class)
@Features(value={EmbeddedAutomationServerFeature.class})
@Deploy(value={"org.nuxeo.ecm.automation.core", "org.nuxeo.ecm.automation.features", "org.nuxeo.ecm.platform.url.api", "org.nuxeo.ecm.platform.url.core", "org.nuxeo.ecm.platform.types.api", "org.nuxeo.ecm.platform.types.core", "org.nuxeo.ecm.automation.io", "org.nuxeo.ecm.platform.restapi.io", "org.nuxeo.ecm.platform.restapi.server"})
@Jetty(port=18090)
@RepositoryConfig(init=AutomationRepositoryInit.class, cleanup=Granularity.METHOD)
public class TestHttpHelpers {
    @Inject
    CoreSession session;
    @Inject
    AutomationService automationService;

    @Test
    public void canUseHttpHelperGET() throws OperationException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("script", "Context.result = HTTP.call(\"Administrator\",\"Administrator\",\"GET\", \"http://localhost:18090/api/v1/path/default-domain\");");
        OperationContext ctx = new OperationContext(this.session);
        this.automationService.run(ctx, "RunScript", params);
        String result = ((Blob)ctx.get((Object)"result")).getString();
        Assert.assertNotEquals((Object)"Internal Server Error", (Object)result);
        Assert.assertTrue((boolean)result.contains("entity-type"));
    }

    @Test
    public void canUseHttpHelperPOST() throws OperationException, IOException {
        String data = "{\"entity-type\": \"document\",\"type\": \"Workspace\",\"name\":\"newName\",\"properties\": {\"dc:title\":\"My title\",\"dc:description\":\" \"}}";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-type", "application/json+nxentity");
        HashMap<String, String> params = new HashMap<String, String>();
        OperationContext ctx = new OperationContext(this.session);
        ctx.put("data", (Object)data);
        ctx.put("headers", headers);
        params.put("script", "Context.result = HTTP.call(\"Administrator\",\"Administrator\",\"POST\", \"http://localhost:18090/api/v1/path/default-domain\", Context.data, Context.headers);");
        this.automationService.run(ctx, "RunScript", params);
        String result = ((Blob)ctx.get((Object)"result")).getString();
        Assert.assertNotEquals((Object)"Internal Server Error", (Object)result);
        Assert.assertTrue((boolean)result.contains("entity-type"));
    }

    @Test
    public void canUseHttpHelperGETStringBlob() throws OperationException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("script", "Context.result = HTTP.call(\"Administrator\",\"Administrator\",\"GET\", \"http://localhost:18090/api/v1/path/testBlob/@blob/file:content\");");
        OperationContext ctx = new OperationContext(this.session);
        this.automationService.run(ctx, "RunScript", params);
        String result = ((Blob)ctx.get((Object)"result")).getString();
        Assert.assertNotEquals((Object)"Internal Server Error", (Object)result);
        Assert.assertTrue((boolean)result.contains("one"));
    }

    @Test
    public void canUseHttpHelperGETBlob() throws OperationException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("script", "Context.result = HTTP.call(\"Administrator\",\"Administrator\",\"GET\", \"http://localhost:18090/api/v1/path/testBlob2/@blob/file:content\");");
        OperationContext ctx = new OperationContext(this.session);
        this.automationService.run(ctx, "RunScript", params);
        Blob result = (Blob)ctx.get((Object)"result");
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((result.getLength() > 0L ? 1 : 0) != 0);
    }
}

