/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonNode;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.nuxeo.ecm.automation.client.RemoteException;
import org.nuxeo.ecm.automation.client.RemoteThrowable;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.jaxrs.impl.HttpAutomationClient;
import org.nuxeo.ecm.automation.client.model.Blobs;
import org.nuxeo.ecm.automation.client.model.DateUtils;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.DocRefs;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.PaginableDocuments;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.nuxeo.ecm.automation.client.model.RecordSet;
import org.nuxeo.ecm.automation.server.test.UploadFileSupport;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractAutomationClientTest {
    protected Document automationTestFolder;
    @Inject
    Session session;
    @Inject
    HttpAutomationClient client;

    @Before
    public void setupTestFolder() throws Exception {
        Document root = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").execute();
        Assert.assertNotNull((Object)root);
        Assert.assertEquals((Object)"/", (Object)root.getPath());
        this.automationTestFolder = (Document)this.session.newRequest("Document.Create").setInput((Object)root).set("type", (Object)"Folder").set("name", (Object)"automation-test-folder").execute();
        Assert.assertNotNull((Object)this.automationTestFolder);
    }

    @After
    public void tearDownTestFolder() throws Exception {
        this.session.newRequest("Document.Delete").setInput((Object)this.automationTestFolder).execute();
    }

    protected File newFile(String content) throws IOException {
        File file = Framework.createTempFile((String)"automation-test-\u00e9\u00e1\u00f2-", (String)".xml");
        FileUtils.writeStringToFile((File)file, (String)content);
        return file;
    }

    @Test
    public void testInvalidLogin() throws Exception {
        try {
            this.client.getSession("foo", "bar");
            Assert.fail((String)"login is supposed to fail");
        }
        catch (RemoteException e) {
            Assert.assertEquals((long)401L, (long)e.getStatus());
        }
    }

    @Test
    public void testRemoteErrorHandling() throws Exception {
        try {
            this.session.newRequest("Repository.GetDocument").set("value", (Object)"/automation-test-folder/unexisting").execute();
            Assert.fail((String)"request is supposed to return 404");
        }
        catch (RemoteException e) {
            Throwable remoteCause;
            Assert.assertEquals((long)404L, (long)e.getStatus());
            Assert.assertThat((Object)remoteCause, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            StackTraceElement[] remoteStack = remoteCause.getStackTrace();
            Assert.assertThat((Object)remoteStack, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            for (remoteCause = e.getRemoteCause(); remoteCause.getCause() != remoteCause && remoteCause.getCause() != null; remoteCause = remoteCause.getCause()) {
            }
            String className = ((JsonNode)((RemoteThrowable)remoteCause).getOtherNodes().get("className")).getTextValue();
            Assert.assertThat((Object)className, (Matcher)Matchers.is((Object)DocumentNotFoundException.class.getName()));
        }
    }

    @Test
    public void testGetCreateUpdateAndRemoveDocument() throws Exception {
        Document folder = (Document)this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"Folder").set("name", (Object)"myfolder").set("properties", (Object)"dc:title=My Folder").execute();
        Assert.assertNotNull((Object)folder);
        Assert.assertEquals((Object)"/automation-test-folder/myfolder", (Object)folder.getPath());
        Assert.assertEquals((Object)"My Folder", (Object)folder.getTitle());
        folder = (Document)this.session.newRequest("Document.Update").setHeader("X-NXDocumentProperties", "*").setInput((Object)folder).set("properties", (Object)"dc:title=My Folder2\ndc:description=test").execute();
        Assert.assertNotNull((Object)folder);
        Assert.assertEquals((Object)"/automation-test-folder/myfolder", (Object)folder.getPath());
        Assert.assertEquals((Object)"My Folder2", (Object)folder.getTitle());
        Assert.assertEquals((Object)"test", (Object)folder.getProperties().getString("dc:description"));
        this.session.newRequest("Document.Delete").setInput((Object)folder).execute();
        Document folder1 = (Document)this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"Folder").set("name", (Object)"myfolder").set("properties", (Object)"dc:title=My Folder").execute();
        Documents folders = new Documents();
        folders.add(folder1);
        this.session.newRequest("Document.Delete").setInput((Object)folders).execute();
        try {
            this.session.newRequest("Repository.GetDocument").set("value", (Object)"/automation-test-folder/myfolder").execute();
            Assert.fail((String)"request is suposed to return 404");
        }
        catch (RemoteException e) {
            Assert.assertEquals((long)404L, (long)e.getStatus());
        }
    }

    @Test
    public void testUpdateDocuments() throws Exception {
        Document folder = (Document)this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"Folder").set("name", (Object)"docsInput").set("properties", (Object)"dc:title=Query Test").execute();
        this.session.newRequest("Document.Create").setInput((Object)folder).set("type", (Object)"Note").set("name", (Object)"note1").set("properties", (Object)"dc:title=Note1").execute();
        this.session.newRequest("Document.Create").setInput((Object)folder).set("type", (Object)"Note").set("name", (Object)"note2").set("properties", (Object)"dc:title=Note2").execute();
        DocRefs refs = new DocRefs();
        refs.add((Object)new DocRef("/automation-test-folder/docsInput/note1"));
        refs.add((Object)new DocRef("/automation-test-folder/docsInput/note2"));
        Documents docs = (Documents)this.session.newRequest("Document.Update").setHeader("X-NXDocumentProperties", "*").setInput((Object)refs).set("properties", (Object)"dc:description=updated").execute();
        Assert.assertEquals((long)2L, (long)docs.size());
        Document doc = (Document)this.session.newRequest("Repository.GetDocument").setHeader("X-NXDocumentProperties", "*").set("value", (Object)"/automation-test-folder/docsInput/note1").execute();
        Assert.assertEquals((Object)"updated", (Object)doc.getString("dc:description"));
        doc = (Document)this.session.newRequest("Repository.GetDocument").setHeader("X-NXDocumentProperties", "*").set("value", (Object)"/automation-test-folder/docsInput/note2").execute();
        Assert.assertEquals((Object)"updated", (Object)doc.getString("dc:description"));
        String now = DateUtils.formatDate((Date)new Date());
        doc = (Document)this.session.newRequest("Document.Update").setHeader("X-NXDocumentProperties", "*").setInput((Object)new DocRef("/automation-test-folder/docsInput/note1")).set("properties", (Object)("dc:valid=" + now)).execute();
        Assert.assertThat((Object)doc.getDate("dc:valid"), (Matcher)Matchers.is((Object)DateUtils.parseDate((String)now)));
    }

    @Test
    public void testUpdateDocumentWithChangeToken() throws Exception {
        Document doc = (Document)this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"Note").set("name", (Object)"note1").set("properties", (Object)"dc:title=Note1").execute();
        String docPath = "/automation-test-folder/note1";
        String changeToken = doc.getChangeToken();
        Assert.assertNotNull((Object)changeToken);
        doc = (Document)this.session.newRequest("Document.Update").setHeader("X-NXDocumentProperties", "*").setInput((Object)new DocRef(docPath)).set("changeToken", (Object)changeToken).set("properties", (Object)"dc:title=Update 1").execute();
        Assert.assertEquals((Object)"Update 1", (Object)doc.getString("dc:title"));
        changeToken = doc.getChangeToken();
        String[] parts = changeToken.split("-");
        String newChangeToken = Long.parseLong(parts[0]) - 1L + "-" + parts[1];
        doc = (Document)this.session.newRequest("Document.Update").setHeader("X-NXDocumentProperties", "*").setInput((Object)new DocRef(docPath)).set("changeToken", (Object)newChangeToken).set("properties", (Object)"dc:title=Update 2").execute();
        Assert.assertEquals((Object)"Update 2", (Object)doc.getString("dc:title"));
        try {
            this.session.newRequest("Document.Update").setHeader("X-NXDocumentProperties", "*").setInput((Object)new DocRef(docPath)).set("changeToken", (Object)"9999-1234").set("properties", (Object)"dc:title=Update 3").execute();
            Assert.fail((String)"should have failed with 409");
        }
        catch (RemoteException e) {
            Assert.assertEquals((long)409L, (long)e.getStatus());
        }
        doc = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)docPath).execute();
        Assert.assertEquals((Object)"Update 2", (Object)doc.getString("dc:title"));
    }

    @Test
    public void testNullProperties() throws Exception {
        Document note = (Document)this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"Note").set("name", (Object)"note1").set("properties", (Object)"dc:title=Note1").execute();
        note = (Document)this.session.newRequest("Repository.GetDocument").setHeader("X-NXDocumentProperties", "*").set("value", (Object)note.getPath()).execute();
        PropertyMap props = note.getProperties();
        Assert.assertTrue((boolean)props.getKeys().contains("dc:source"));
        Assert.assertNull((Object)note.getString("dc:source"));
    }

    @Test
    public void testQuery() throws Exception {
        Document folder = (Document)this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"Folder").set("name", (Object)"queryTest").set("properties", (Object)"dc:title=Query Test").execute();
        this.session.newRequest("Document.Create").setInput((Object)folder).set("type", (Object)"Note").set("name", (Object)"note1").set("properties", (Object)"dc:title=Note1").execute();
        this.session.newRequest("Document.Create").setInput((Object)folder).set("type", (Object)"Note").set("name", (Object)"note2").set("properties", (Object)"dc:title=Note2").execute();
        Documents docs = (Documents)this.session.newRequest("Repository.Query").set("query", (Object)"SELECT * FROM Note WHERE ecm:path STARTSWITH '/automation-test-folder/queryTest' ").execute();
        Assert.assertEquals((long)2L, (long)docs.size());
        String title1 = docs.get(0).getTitle();
        String title2 = docs.get(1).getTitle();
        Assert.assertTrue((title1.equals("Note1") && title2.equals("Note2") || title1.equals("Note2") && title2.equals("Note1") ? 1 : 0) != 0);
        docs = (Documents)this.session.newRequest("Document.GetChildren").setInput((Object)folder).execute();
        Assert.assertEquals((long)2L, (long)docs.size());
        title1 = docs.get(0).getTitle();
        title2 = docs.get(1).getTitle();
        Assert.assertTrue((title1.equals("Note1") && title2.equals("Note2") || title1.equals("Note2") && title2.equals("Note1") ? 1 : 0) != 0);
    }

    @Test
    public void testQueryAndFetch() throws Exception {
        Document folder = (Document)this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"Folder").set("name", (Object)"queryTest").set("properties", (Object)"dc:title=Query Test").execute();
        this.session.newRequest("Document.Create").setInput((Object)folder).set("type", (Object)"Note").set("name", (Object)"note1").set("properties", (Object)"dc:title=Note1\ndc:description=Desc1").execute();
        this.session.newRequest("Document.Create").setInput((Object)folder).set("type", (Object)"Note").set("name", (Object)"note2").set("properties", (Object)"dc:title=Note2\ndc:description=Desc2").execute();
        RecordSet result = (RecordSet)this.session.newRequest("Repository.ResultSetPageProvider").set("query", (Object)"SELECT dc:title, ecm:uuid, dc:description FROM Note WHERE ecm:path STARTSWITH '/automation-test-folder/queryTest' order by dc:title ").execute();
        Assert.assertEquals((long)2L, (long)result.size());
        String title1 = (String)((Map)result.get(0)).get("dc:title");
        String title2 = (String)((Map)result.get(1)).get("dc:title");
        Assert.assertTrue((title1.equals("Note1") && title2.equals("Note2") ? 1 : 0) != 0);
        String desc1 = (String)((Map)result.get(0)).get("dc:description");
        String desc2 = (String)((Map)result.get(1)).get("dc:description");
        Assert.assertTrue((desc1.equals("Desc1") && desc2.equals("Desc2") ? 1 : 0) != 0);
    }

    @Test
    public void testAttachAndGetFile() throws Exception {
        File file = this.newFile("<doc>mydoc</doc>");
        String filename = file.getName();
        FileBlob fb = new FileBlob(file);
        fb.setMimeType("text/xml");
        this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"File").set("name", (Object)"myfile").set("properties", (Object)"dc:title=My File").execute();
        FileBlob blob = (FileBlob)this.session.newRequest("Blob.Attach").setHeader("X-NXVoidOperation", "true").setInput((Object)fb).set("document", (Object)"/automation-test-folder/myfile").execute();
        Assert.assertNull((Object)blob);
        Document doc = (Document)this.session.newRequest("Repository.GetDocument").setHeader("X-NXDocumentProperties", "*").set("value", (Object)"/automation-test-folder/myfile").execute();
        PropertyMap map = doc.getProperties().getMap("file:content");
        Assert.assertEquals((Object)filename, (Object)map.getString("name"));
        Assert.assertEquals((Object)"text/xml", (Object)map.getString("mime-type"));
        String path = map.getString("data");
        blob = (FileBlob)this.session.getFile(path);
        Assert.assertNotNull((Object)blob);
        Assert.assertEquals((Object)filename, (Object)blob.getFileName());
        Assert.assertEquals((Object)"text/xml", (Object)blob.getMimeType());
        Assert.assertEquals((Object)"<doc>mydoc</doc>", (Object)IOUtils.toString((InputStream)blob.getStream(), (String)"utf-8"));
        blob.getFile().delete();
        blob = (FileBlob)this.session.newRequest("Document.GetBlob").setInput((Object)doc).set("xpath", (Object)"file:content").execute();
        Assert.assertNotNull((Object)blob);
        Assert.assertEquals((Object)filename, (Object)blob.getFileName());
        Assert.assertEquals((Object)"text/xml", (Object)blob.getMimeType());
        Assert.assertEquals((Object)"<doc>mydoc</doc>", (Object)IOUtils.toString((InputStream)blob.getStream(), (String)"utf-8"));
        blob.getFile().delete();
    }

    @Test
    @Ignore(value="NXP-22652")
    public void testGetBlobs() throws Exception {
        Document note = (Document)this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"Note").set("name", (Object)"blobs").set("properties", (Object)"dc:title=Blobs Test").execute();
        File file1 = this.newFile("<doc>mydoc1</doc>");
        File file2 = this.newFile("<doc>mydoc2</doc>");
        String filename1 = file1.getName();
        String filename2 = file2.getName();
        FileBlob fb1 = new FileBlob(file1);
        fb1.setMimeType("text/xml");
        FileBlob fb2 = new FileBlob(file2);
        fb2.setMimeType("text/xml");
        Blobs blobs = new Blobs();
        FileBlob blob = (FileBlob)this.session.newRequest("Blob.AttachOnDocument").setHeader("X-NXVoidOperation", "true").setInput((Object)fb1).set("document", (Object)"/automation-test-folder/blobs").set("xpath", (Object)"files:files").execute();
        Assert.assertNull((Object)blob);
        blob = (FileBlob)this.session.newRequest("Blob.AttachOnDocument").setHeader("X-NXVoidOperation", "true").setInput((Object)fb2).set("document", (Object)"/automation-test-folder/blobs").set("xpath", (Object)"files:files").execute();
        Assert.assertNull((Object)blob);
        note = (Document)this.session.newRequest("Repository.GetDocument").setHeader("X-NXDocumentProperties", "*").set("value", (Object)"/automation-test-folder/blobs").execute();
        PropertyList list = note.getProperties().getList("files:files");
        Assert.assertEquals((long)2L, (long)list.size());
        PropertyMap map = list.getMap(0).getMap("file");
        Assert.assertEquals((Object)filename1, (Object)map.getString("name"));
        Assert.assertEquals((Object)"text/xml", (Object)map.getString("mime-type"));
        String path = map.getString("data");
        blob = (FileBlob)this.session.getFile(path);
        Assert.assertNotNull((Object)blob);
        Assert.assertEquals((Object)filename1, (Object)blob.getFileName());
        Assert.assertEquals((Object)"text/xml", (Object)blob.getMimeType());
        Assert.assertEquals((Object)"<doc>mydoc1</doc>", (Object)IOUtils.toString((InputStream)blob.getStream(), (String)"utf-8"));
        blob.getFile().delete();
        map = list.getMap(1).getMap("file");
        Assert.assertEquals((Object)filename2, (Object)map.getString("name"));
        Assert.assertEquals((Object)"text/xml", (Object)map.getString("mime-type"));
        path = map.getString("data");
        blob = (FileBlob)this.session.getFile(path);
        Assert.assertNotNull((Object)blob);
        Assert.assertEquals((Object)filename2, (Object)blob.getFileName());
        Assert.assertEquals((Object)"text/xml", (Object)blob.getMimeType());
        Assert.assertEquals((Object)"<doc>mydoc2</doc>", (Object)IOUtils.toString((InputStream)blob.getStream(), (String)"utf-8"));
        blob.getFile().delete();
        blobs = (Blobs)this.session.newRequest("Document.GetBlobsByProperty").setInput((Object)note).set("xpath", (Object)"files:files").execute();
        Assert.assertNotNull((Object)blob);
        Assert.assertEquals((long)2L, (long)blobs.size());
        blob = (FileBlob)blobs.get(0);
        Assert.assertEquals((Object)filename1, (Object)blob.getFileName());
        Assert.assertEquals((Object)"text/xml", (Object)blob.getMimeType());
        Assert.assertEquals((Object)"<doc>mydoc1</doc>", (Object)IOUtils.toString((InputStream)blob.getStream(), (String)"utf-8"));
        blob.getFile().delete();
        blob = (FileBlob)blobs.get(1);
        Assert.assertEquals((Object)filename2, (Object)blob.getFileName());
        Assert.assertEquals((Object)"text/xml", (Object)blob.getMimeType());
        Assert.assertEquals((Object)"<doc>mydoc2</doc>", (Object)IOUtils.toString((InputStream)blob.getStream(), (String)"utf-8"));
        blob.getFile().delete();
    }

    @Test
    public void testUploadBlobs() throws Exception {
        File file1 = this.newFile("<doc>mydoc1</doc>");
        File file2 = this.newFile("<doc>mydoc2</doc>");
        String filename1 = file1.getName();
        String filename2 = file2.getName();
        FileBlob fb1 = new FileBlob(file1);
        fb1.setMimeType("text/xml");
        FileBlob fb2 = new FileBlob(file2);
        fb2.setMimeType("text/xml");
        Blobs blobs = new Blobs();
        blobs.add((Object)fb1);
        blobs.add((Object)fb2);
        FileBlob zip = (FileBlob)this.session.newRequest("Blob.CreateZip").set("filename", (Object)"test.zip").setInput((Object)blobs).execute();
        Assert.assertNotNull((Object)zip);
        try (ZipFile zf = new ZipFile(zip.getFile());){
            ZipEntry entry1 = zf.getEntry(filename1);
            Assert.assertNotNull((Object)entry1);
            ZipEntry entry2 = zf.getEntry(filename2);
            Assert.assertNotNull((Object)entry2);
            zip.getFile().delete();
        }
    }

    @Test
    public void testUploadSmallFile() throws Exception {
        UploadFileSupport.DigestMockInputStream source = new UploadFileSupport.DigestMockInputStream(100L);
        FileInputStream in = new UploadFileSupport(this.session, this.automationTestFolder.getPath()).testUploadFile(source);
        byte[] sentSum = source.digest.digest();
        while (in.available() > 0) {
            source.digest.update((byte)in.read());
        }
        byte[] receivedSum = source.digest.digest();
        Assert.assertTrue((String)("Expected (sent) bytes array: " + Arrays.toString(sentSum) + " - Actual (received) bytes array: " + Arrays.toString(receivedSum)), (boolean)MessageDigest.isEqual(sentSum, receivedSum));
    }

    @Test
    public void queriesArePaginable() throws Exception {
        Document folder = (Document)this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"Folder").set("name", (Object)"docsInput").set("properties", (Object)"dc:title=Query Test").execute();
        Document[] notes = new Document[15];
        for (int i = 0; i < 14; ++i) {
            notes[i] = (Document)this.session.newRequest("Document.Create").setInput((Object)folder).set("type", (Object)"Note").set("name", (Object)("note" + i)).set("properties", (Object)("dc:title=Note" + i)).execute();
        }
        Documents docs = (Documents)this.session.newRequest("Repository.Query").set("query", (Object)"SELECT * from Document WHERE ecm:path STARTSWITH '/automation-test-folder/'").execute();
        PaginableDocuments cursor = (PaginableDocuments)this.session.newRequest("Repository.PageProvider").set("query", (Object)"SELECT * from Document WHERE ecm:path STARTSWITH '/automation-test-folder/'").set("pageSize", (Object)2).execute();
        int pageSize = cursor.getPageSize();
        int pageCount = cursor.getNumberOfPages();
        int totalSize = cursor.getResultsCount();
        Assert.assertThat((Object)cursor.size(), (Matcher)Matchers.is((Object)2));
        int size = docs.size();
        Assert.assertThat((Object)totalSize, (Matcher)Matchers.is((Object)size));
        Assert.assertThat((Object)pageSize, (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)pageCount, (Matcher)Matchers.is((Object)(size / 2 + size % 2)));
        Assert.assertThat((Object)cursor.getResultsCount(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf((pageCount - 1) * pageSize)));
    }

    @Test
    public void testSetArrayProperty() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("dc:title", "My Test Folder");
        props.put("dc:description", "test");
        props.put("dc:subjects", "art,sciences,biology");
        Document folder = (Document)this.session.newRequest("Document.Create").setHeader("X-NXDocumentProperties", "*").setInput((Object)this.automationTestFolder).set("type", (Object)"Folder").set("name", (Object)"myfolder2").set("properties", props).execute();
        Assert.assertEquals((Object)"My Test Folder", (Object)folder.getString("dc:title"));
        Assert.assertEquals((Object)"test", (Object)folder.getString("dc:description"));
        PropertyList ar = (PropertyList)folder.getProperties().get("dc:subjects");
        Assert.assertEquals((long)3L, (long)ar.size());
        Assert.assertEquals((Object)"art", (Object)ar.getString(0));
        Assert.assertEquals((Object)"sciences", (Object)ar.getString(1));
        Assert.assertEquals((Object)"biology", (Object)ar.getString(2));
    }

    @Test
    public void testSchemaSelection() throws Exception {
        try {
            Document root = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").execute();
            Assert.assertEquals((long)1L, (long)root.getProperties().size());
            this.session.setDefaultSchemas("common,dublincore,file");
            root = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").execute();
            Assert.assertTrue((root.getProperties().size() > 15 ? 1 : 0) != 0);
            root = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").setHeader("X-NXDocumentProperties", "common").execute();
            Assert.assertEquals((long)3L, (long)root.getProperties().size());
            this.session.setDefaultSchemas(null);
            root = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").execute();
            Assert.assertEquals((long)1L, (long)root.getProperties().size());
        }
        finally {
            this.session.setDefaultSchemas(null);
        }
    }

    @Test
    public void testBadAccess() throws Exception {
        try {
            this.session.newRequest("Repository.GetDocument").set("value", (Object)"/foo").execute();
            Assert.fail((String)"no exception caught");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Test
    public void testLock() throws Exception {
        Document folder = (Document)this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"Folder").set("name", (Object)"myfolder").set("properties", (Object)"dc:title=My Folder").execute();
        Document doc = (Document)this.session.newRequest("Repository.GetDocument").setHeader("X-NXDocumentProperties", "*").set("value", (Object)folder.getPath()).execute();
        Assert.assertNull((Object)doc.getLock());
        this.session.newRequest("Document.Lock").setHeader("X-NXVoidOperation", "*").setInput((Object)doc).execute();
        doc = (Document)this.session.newRequest("Repository.GetDocument").setHeader("X-NXDocumentProperties", "*").setHeader("X-NXfetch.document", "lock").set("value", (Object)doc.getPath()).execute();
        Assert.assertNotNull((Object)doc.getLock());
        Assert.assertEquals((Object)"Administrator", (Object)doc.getLockOwner());
        Assert.assertNotNull((Object)doc.getLockCreated());
    }

    @Test
    public void testEncoding() throws Exception {
        String title = "\u00e9\u00e8\u00ea\u00eb\u00e0\u00e0\u00e4\u00ec\u00ee\u00ef\u00f9\u00fb\u00f9";
        Document folder = (Document)this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"Folder").set("name", (Object)"myfolder").set("properties", (Object)("dc:title=" + title)).execute();
        folder = (Document)this.session.newRequest("Repository.GetDocument").setHeader("X-NXDocumentProperties", "*").set("value", (Object)folder.getPath()).execute();
        Assert.assertEquals((Object)folder.getTitle(), (Object)title);
    }

    @Test
    public void testGetEmptyBlobsList() throws Exception {
        Document file = (Document)this.session.newRequest("Document.Create").setInput((Object)this.automationTestFolder).set("type", (Object)"File").set("name", (Object)"blobs").set("properties", (Object)"dc:title=Blobs Test").execute();
        Blobs blobs = (Blobs)this.session.newRequest("Document.GetBlobsByProperty").setInput((Object)file).execute();
        Assert.assertNotNull((Object)blobs);
        Assert.assertTrue((boolean)blobs.isEmpty());
    }
}

