/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.test;

import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.test.AutomationFeature;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.Jetty;

@RunWith(value=FeaturesRunner.class)
@Features(value={AutomationFeature.class})
@Deploy(value={"org.nuxeo.ecm.platform.types.core", "org.nuxeo.ecm.platform.filemanager.core", "org.nuxeo.ecm.platform.userworkspace.api", "org.nuxeo.ecm.platform.userworkspace.core", "org.nuxeo.ecm.platform.userworkspace.types"})
@Jetty(port=18080)
public class CanCreateInWorkspacesFromBlobTest {
    @Inject
    AutomationService automation;
    @Inject
    CoreSession session;

    @Test
    public void createUserFileWithoutCurrentDocument() throws OperationException {
        try (OperationContext context = new OperationContext(this.session);){
            StringBlob input = new StringBlob("blah blah blah");
            input.setFilename("blah");
            context.setInput((Object)input);
            DocumentModel result = (DocumentModel)this.automation.run(context, "UserWorkspace.CreateDocumentFromBlob");
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)result.getName(), (Object)"blah");
        }
    }
}

