/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.test;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.impl.blob.AsyncBlob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.test.PlatformFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={PlatformFeature.class})
@Deploy(value={"org.nuxeo.ecm.automation.core"})
public class TestBulkDownloadOperation {
    private static final int MAX_DOC = 10;
    @Inject
    protected DownloadService downloadService;
    @Inject
    protected CoreSession session;
    @Inject
    protected AutomationService automationService;
    @Inject
    WorkManager workManager;

    @Test
    public void iCanBulkDownloadFiles() throws IOException, OperationException, InterruptedException {
        DocumentModelListImpl docs = new DocumentModelListImpl();
        for (int i = 0; i < 10; ++i) {
            DocumentModel doc = this.session.createDocumentModel("/", "TestFile" + i, "File");
            doc.setProperty("dublincore", "title", (Object)("TestTitle" + i));
            Blob blob1 = Blobs.createBlob((String)("test" + i));
            String blobFilename = "test" + i + ".txt";
            blob1.setFilename(blobFilename);
            BlobHolder bh1 = (BlobHolder)doc.getAdapter(BlobHolder.class);
            bh1.setBlob(blob1);
            doc = this.session.createDocument(doc);
            this.session.save();
            docs.add((Object)doc);
        }
        OperationChain chain = new OperationChain("test-chain");
        chain.add("Blob.BulkDownload");
        OperationContext ctx = new OperationContext(this.session);
        ctx.setInput((Object)docs);
        Blob resultBlob = (Blob)this.automationService.run(ctx, "Blob.BulkDownload");
        Assert.assertNotNull((Object)resultBlob);
        this.awaitZipWorks();
        if (resultBlob instanceof AsyncBlob) {
            TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
            TransientStore ts = tss.getStore("download");
            List blobs = ts.getBlobs(((AsyncBlob)resultBlob).getKey());
            Assert.assertNotNull((Object)blobs);
            Assert.assertEquals((long)1L, (long)blobs.size());
            resultBlob = (Blob)blobs.get(0);
            Assert.assertTrue((boolean)(resultBlob instanceof FileBlob));
        }
        Assert.assertTrue((resultBlob.getLength() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)resultBlob.getMimeType(), (Object)"application/zip");
        try (CloseableFile source = resultBlob.getCloseableFile();
             ZipFile zip = new ZipFile(source.getFile());){
            Assert.assertEquals((long)10L, (long)zip.size());
        }
    }

    protected void awaitZipWorks() throws InterruptedException {
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        Assert.assertTrue((boolean)this.workManager.awaitCompletion("blobs", 30L, TimeUnit.SECONDS));
    }
}

