/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.test;

import java.io.IOException;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.jaxrs.impl.HttpAutomationClient;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.OperationDocumentation;
import org.nuxeo.ecm.automation.test.EmbeddedAutomationServerFeature;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.Jetty;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={EmbeddedAutomationServerFeature.class})
@Deploy(value={"org.nuxeo.ecm.automation.scripting"})
@LocalDeploy(value={"org.nuxeo.ecm.automation.test:operation-contrib.xml", "org.nuxeo.ecm.automation.test:chain-scripting-operation-contrib.xml"})
@Jetty(port=18080)
@RepositoryConfig(cleanup=Granularity.METHOD)
public class TestRemoteAutomationScript {
    @Inject
    Session session;
    @Inject
    AutomationService service;
    @Inject
    HttpAutomationClient client;

    protected Documents getDocuments() throws IOException {
        Document root = (Document)this.session.newRequest("Repository.GetDocument").set("value", (Object)"/").execute();
        Document simple = (Document)this.session.newRequest("Document.Create").setInput((Object)root).set("type", (Object)"File").set("name", (Object)"Simple").set("properties", (Object)"dc:title=Simple\n").execute();
        Documents docs = new Documents();
        docs.add(simple);
        docs.add(root);
        return docs;
    }

    @Test
    public void canHandleDocumentSentRemotely() throws IOException {
        Document document = (Document)this.session.newRequest("javascript.RemoteScriptWithDoc").setInput((Object)this.getDocuments().get(0)).execute();
        Assert.assertNotNull((Object)document);
        Assert.assertEquals((Object)"Simple", (Object)document.getTitle());
    }

    @Test
    public void canHandleDocumentsSentRemotely() throws IOException {
        Documents documents = (Documents)this.session.newRequest("javascript.RemoteScriptWithDocs").setInput((Object)this.getDocuments()).execute();
        Assert.assertNotNull((Object)documents);
        Assert.assertEquals((long)2L, (long)documents.size());
        Assert.assertEquals((Object)"Simple", (Object)documents.get(0).getTitle());
    }

    @Test
    public void testRemoteChainWithScriptingOp() throws Exception {
        OperationDocumentation opd = this.session.getOperation("testChain2");
        Assert.assertNotNull((Object)opd);
        Assert.assertNotNull((Object)this.service.getOperation("testChain2").getDocumentation().getOperations());
        Document doc = (Document)this.session.newRequest("testChain2").setInput((Object)DocRef.newRef((String)"/")).execute();
        Assert.assertNotNull((Object)doc);
    }
}

