/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.osgi.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.osgi.application.LoaderConstants;
import org.nuxeo.osgi.application.MutableClassLoader;
import org.nuxeo.osgi.application.MutableClassLoaderDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkBootstrap
implements LoaderConstants {
    protected static final String DEFAULT_BUNDLES_CP = "bundles/*";
    protected static final String DEFAULT_LIBS_CP = "lib/*:.:config";
    private static final Log log = LogFactory.getLog(FrameworkBootstrap.class);
    protected File home;
    protected MutableClassLoader loader;
    protected Map<String, Object> env;
    protected Class<?> frameworkLoaderClass;
    protected long startTime;
    protected boolean scanForNestedJars = true;
    protected boolean flushCache = false;
    private static final int BUFFER_SIZE = 65536;
    private static final int MAX_BUFFER_SIZE = 0x100000;
    private static final int MIN_BUFFER_SIZE = 8192;

    public FrameworkBootstrap(ClassLoader cl, File home) throws IOException {
        this(new MutableClassLoaderDelegate(cl), home);
    }

    public FrameworkBootstrap(MutableClassLoader loader, File home) throws IOException {
        this.home = home.getCanonicalFile();
        this.loader = loader;
        this.initializeEnvironment();
    }

    public void setHostName(String value) {
        this.env.put("org.nuxeo.app.host.name", value);
    }

    public void setHostVersion(String value) {
        this.env.put("org.nuxeo.app.host.version", value);
    }

    public void setDoPreprocessing(boolean doPreprocessing) {
        this.env.put("org.nuxeo.app.preprocessing", Boolean.toString(doPreprocessing));
    }

    public void setDevMode(String devMode) {
        this.env.put("org.nuxeo.app.devmode", devMode);
    }

    public void setFlushCache(boolean flushCache) {
        this.flushCache = flushCache;
    }

    public void setScanForNestedJars(boolean scanForNestedJars) {
        this.scanForNestedJars = scanForNestedJars;
    }

    public Map<String, Object> env() {
        return this.env;
    }

    public MutableClassLoader getLoader() {
        return this.loader;
    }

    public ClassLoader getClassLoader() {
        return this.loader.getClassLoader();
    }

    public File getHome() {
        return this.home;
    }

    public void initialize() throws Exception {
        this.startTime = System.currentTimeMillis();
        List<File> bundleFiles = this.buildClassPath();
        this.frameworkLoaderClass = this.getClassLoader().loadClass("org.nuxeo.osgi.application.loader.FrameworkLoader");
        Method init = this.frameworkLoaderClass.getMethod("initialize", ClassLoader.class, File.class, List.class, Map.class);
        init.invoke(null, this.loader.getClassLoader(), this.home, bundleFiles, this.env);
    }

    public void start() throws Exception {
        if (this.frameworkLoaderClass == null) {
            throw new IllegalStateException("Framework Loader was not initialized. Call initialize() method first");
        }
        Method start = this.frameworkLoaderClass.getMethod("start", new Class[0]);
        start.invoke(null, new Object[0]);
        this.printStartedMessage();
    }

    public void stop() throws Exception {
        if (this.frameworkLoaderClass == null) {
            throw new IllegalStateException("Framework Loader was not initialized. Call initialize() method first");
        }
        Method stop = this.frameworkLoaderClass.getMethod("stop", new Class[0]);
        stop.invoke(null, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeEnvironment() throws IOException {
        System.setProperty("org.nuxeo.app.home", this.home.getAbsolutePath());
        this.env = new HashMap<String, Object>();
        this.env.put("org.nuxeo.app.bundles", DEFAULT_BUNDLES_CP);
        this.env.put("org.nuxeo.app.libs", DEFAULT_LIBS_CP);
        File file = new File(this.home, "launcher.properties");
        if (!file.isFile()) {
            return;
        }
        Properties p = new Properties();
        FileInputStream in = new FileInputStream(file);
        try {
            p.load(in);
            this.env.putAll(p);
            String v = (String)this.env.get("org.nuxeo.app.scanForNestedJars");
            if (v != null) {
                this.scanForNestedJars = Boolean.parseBoolean(v);
            }
            if ((v = (String)this.env.get("org.nuxeo.app.flushCache")) != null) {
                this.flushCache = Boolean.parseBoolean(v);
            }
        }
        finally {
            in.close();
        }
    }

    protected void printStartedMessage() {
        log.info((Object)("Framework started in " + (System.currentTimeMillis() - this.startTime) / 1000L + " sec."));
    }

    protected File newFile(String path) throws IOException {
        if (path.startsWith("/")) {
            return new File(path).getCanonicalFile();
        }
        return new File(this.home, path).getCanonicalFile();
    }

    protected List<File> buildClassPath() throws IOException {
        ArrayList<File> bundleFiles = new ArrayList<File>();
        String libsCp = (String)this.env.get("org.nuxeo.app.libs");
        if (libsCp != null) {
            this.buildLibsClassPath(libsCp);
        }
        String bundlesCp = (String)this.env.get("org.nuxeo.app.bundles");
        if (libsCp != null) {
            this.buildBundlesClassPath(bundlesCp, bundleFiles);
        }
        this.extractNestedJars(bundleFiles, new File(this.home, "tmp/nested-jars"));
        return bundleFiles;
    }

    protected void buildLibsClassPath(String libsCp) throws IOException {
        String[] ar = libsCp.split(":");
        for (int i = 0; i < ar.length; ++i) {
            File entryFile;
            String entry = ar[i];
            if (entry.endsWith("/*")) {
                entryFile = this.newFile(entry.substring(0, entry.length() - 2));
                File[] files = entryFile.listFiles();
                if (files == null) continue;
                for (File file : files) {
                    this.loader.addURL(file.toURI().toURL());
                }
                continue;
            }
            entryFile = this.newFile(entry);
            this.loader.addURL(entryFile.toURI().toURL());
        }
    }

    protected void buildBundlesClassPath(String bundlesCp, List<File> bundleFiles) throws IOException {
        String[] ar = bundlesCp.split(":");
        for (int i = 0; i < ar.length; ++i) {
            File entryFile;
            String entry = ar[i];
            if (entry.endsWith("/*")) {
                entryFile = this.newFile(entry.substring(0, entry.length() - 2));
                File[] files = entryFile.listFiles();
                if (files == null) continue;
                for (File file : files) {
                    String path = file.getPath();
                    if (!path.endsWith(".jar") && !path.endsWith(".zip") && !path.endsWith(".war")) continue;
                    bundleFiles.add(file);
                    this.loader.addURL(file.toURI().toURL());
                }
                continue;
            }
            entryFile = this.newFile(entry);
            bundleFiles.add(entryFile);
            this.loader.addURL(entryFile.toURI().toURL());
        }
    }

    protected void extractNestedJars(List<File> bundleFiles, File dir) throws IOException {
        if (!this.scanForNestedJars) {
            return;
        }
        if (dir.isDirectory()) {
            if (this.flushCache) {
                FrameworkBootstrap.deleteAll(dir);
            } else {
                File[] files = dir.listFiles();
                if (files != null) {
                    for (File f : files) {
                        this.loader.addURL(f.toURI().toURL());
                    }
                }
                return;
            }
        }
        dir.mkdirs();
        for (File f : bundleFiles) {
            if (!f.isFile()) continue;
            this.extractNestedJars(f, dir);
        }
    }

    protected void extractNestedJars(File file, File tmpDir) throws IOException {
        JarFile jarFile = new JarFile(file);
        String fileName = file.getName();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String path = entry.getName();
            if (!entry.getName().endsWith(".jar")) continue;
            String name = path.replace('/', '_');
            File dest = new File(tmpDir, fileName + '-' + name);
            this.extractNestedJar(jarFile, entry, dest);
            this.loader.addURL(dest.toURI().toURL());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractNestedJar(JarFile file, ZipEntry entry, File dest) throws IOException {
        InputStream in = null;
        try {
            in = file.getInputStream(entry);
            FrameworkBootstrap.copyToFile(in, dest);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static void deleteAll(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                FrameworkBootstrap.deleteAll(f);
            }
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File file) throws IOException {
        FileInputStream in = new FileInputStream(src);
        try {
            FrameworkBootstrap.copyToFile(in, file);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyToFile(InputStream in, File file) throws IOException {
        FileOutputStream out = null;
        try {
            int read;
            out = new FileOutputStream(file);
            byte[] buffer = FrameworkBootstrap.createBuffer(in.available());
            while ((read = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    private static byte[] createBuffer(int preferredSize) {
        if (preferredSize < 1) {
            preferredSize = 65536;
        }
        if (preferredSize > 0x100000) {
            preferredSize = 0x100000;
        } else if (preferredSize < 8192) {
            preferredSize = 8192;
        }
        return new byte[preferredSize];
    }

    public static File findFileStartingWidth(File dir, String prefix) {
        String[] names = dir.list();
        if (names != null) {
            for (String name : names) {
                if (!name.startsWith(prefix)) continue;
                return new File(dir, name);
            }
        }
        return null;
    }

    public static void copyTree(File src, File dst) throws IOException {
        if (src.isFile()) {
            FrameworkBootstrap.copyFile(src, dst);
        } else if (src.isDirectory()) {
            File[] files;
            if (dst.exists()) {
                dst = new File(dst, src.getName());
                dst.mkdir();
            } else {
                dst.mkdirs();
            }
            for (File file : files = src.listFiles()) {
                FrameworkBootstrap.copyTree(file, dst);
            }
        }
    }
}

