/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.primitives;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.schema.types.PrimitiveType;

public final class BinaryType
extends PrimitiveType {
    public static final String ID = "binary";
    public static final BinaryType INSTANCE = new BinaryType();
    private static final long serialVersionUID = 3424217422110579879L;

    private BinaryType() {
        super(ID);
    }

    public boolean validate(Object object) {
        return true;
    }

    public Object convert(Object value) {
        if (value instanceof CharSequence) {
            return new ByteArrayInputStream(value.toString().getBytes());
        }
        if (value instanceof byte[]) {
            return new ByteArrayInputStream((byte[])value);
        }
        if (value instanceof InputStream) {
            return value;
        }
        return null;
    }

    public static Object parseString(String str) {
        return new ByteArrayInputStream(str.getBytes());
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    public Object decode(String str) {
        if (str == null) {
            return null;
        }
        return new ByteArrayInputStream(str.getBytes());
    }

    public String encode(Object object) {
        if (object instanceof InputStream) {
            try {
                return FileUtils.read((InputStream)((InputStream)object));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return object.toString();
    }
}

