/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands;

import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.shell.Command;
import org.nuxeo.ecm.shell.CommandDescriptor;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.CommandLineService;
import org.nuxeo.ecm.shell.CommandOption;
import org.nuxeo.runtime.api.Framework;

public class HelpCommand
implements Command {
    private static final Log log = LogFactory.getLog(HelpCommand.class);
    private CommandLineService service;

    public void run(CommandLine cmdLine) throws Exception {
        this.service = (CommandLineService)((Object)Framework.getService(CommandLineService.class));
        String[] elements = cmdLine.getParameters();
        if (elements.length == 0) {
            this.printGlobalHelp(System.out);
        } else {
            this.printCommandHelp(elements[0], System.out);
        }
    }

    void printHelp(PrintStream out, String help, String ident) {
        for (String line : HelpCommand.trimHelpLines(help)) {
            out.println(ident + line);
        }
    }

    public void printGlobalHelp(PrintStream out) {
        out.println("Syntax: application command [options]");
        out.println();
        out.println("The following commands are supported:");
        for (CommandDescriptor cd : this.service.getSortedCommands()) {
            out.println(" * " + cd.getName() + " - " + cd.getDescription());
        }
        out.println();
        out.println("Global options: ");
        for (CommandOption opt : this.service.getCommandOptions()) {
            String help;
            if (opt.getCommand() != null || (help = opt.getHelp()) == null || help.length() <= 0) continue;
            String msg = "  --" + opt.getName();
            if (opt.getShortcut() != null) {
                msg = msg + " [shortcut: -" + opt.getShortcut() + ']';
            }
            out.println(msg);
            this.printHelp(out, help, "      ");
        }
        out.println();
        out.println("For more information on a command run \"help command\".");
        out.println("For auto-completion press TAB key.");
        out.println();
    }

    public void printCommandHelp(String cmd, PrintStream out) {
        CommandDescriptor cd = this.service.getCommand(cmd);
        if (cd == null) {
            log.error((Object)("Unknown command: " + cmd));
            return;
        }
        try {
            cd.newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        out.println("Command: " + cd.getName() + " - " + cd.getDescription());
        out.println();
        out.print("Aliases: ");
        Object[] aliases = cd.getAliases();
        if (aliases == null || aliases.length == 0) {
            out.println("N/A");
        } else {
            out.println(StringUtils.join((Object[])aliases, (String)", "));
        }
        out.println();
        out.println("Options: ");
        if (!cd.hasOptions()) {
            out.println("N/A");
        } else {
            for (CommandOption opt : cd.getOptions()) {
                String help = opt.getHelp();
                if (help == null || help.length() <= 0) continue;
                String msg = "  --" + opt.getName();
                if (opt.getShortcut() != null) {
                    msg = msg + " [shortcut: -" + opt.getShortcut() + ']';
                }
                out.println(msg);
                this.printHelp(out, help, "      ");
            }
        }
        out.println();
        this.printHelp(out, cd.getHelp(), "");
        out.println();
    }

    public static String[] trimHelpLines(String help) {
        int i;
        String[] rawLines = help.split("\n|(\r\n)|\r");
        ArrayList<String> lines = new ArrayList<String>();
        int start = 0;
        for (int i2 = 0; i2 < rawLines.length; ++i2) {
            start = i2;
            String line = rawLines[i2].trim();
            if (line.length() > 0) break;
        }
        int end = 0;
        for (i = rawLines.length - 1; i >= 0; --i) {
            end = i;
            String line = rawLines[i].trim();
            if (line.length() > 0) break;
        }
        for (i = start; i <= end; ++i) {
            lines.add(rawLines[i].trim());
        }
        return lines.toArray(new String[lines.size()]);
    }
}

