/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands;

import java.io.File;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.EJBAccessException;
import jline.Completor;
import jline.ConsoleReader;
import jline.History;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.client.NuxeoClient;
import org.nuxeo.ecm.shell.CommandDescriptor;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.CommandLineService;
import org.nuxeo.ecm.shell.commands.CompositeCompletor;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;
import org.nuxeo.runtime.api.Framework;

public class InteractiveCommand
extends AbstractCommand {
    private static final Log log = LogFactory.getLog(InteractiveCommand.class);
    private CommandLineService service;
    private static ConsoleReader console;

    public static ConsoleReader getConsole() {
        return console;
    }

    public CommandLineService getService() {
        return this.service;
    }

    public void run(CommandLine cmdLine) throws Exception {
        CommandLineReturn commandLineReturn;
        String line;
        this.service = (CommandLineService)((Object)Framework.getService(CommandLineService.class));
        console = new ConsoleReader();
        CompositeCompletor completor = new CompositeCompletor(this);
        console.addCompletor((Completor)completor);
        String userHome = System.getProperty("user.home");
        log.trace((Object)("userHome = " + userHome));
        System.out.println();
        File historyFile = new File(userHome, ".nuxeoshell_history");
        log.trace((Object)("historyFile = " + historyFile));
        History commandLineHistory = new History(historyFile);
        console.setHistory(commandLineHistory);
        this.context.setInteractive(true);
        do {
            this.updatePrompt();
            line = console.readLine();
        } while (line != null && ((line = line.trim()).length() == 0 || (commandLineReturn = this.processInput(line)) != CommandLineReturn.QUIT));
    }

    public static String[] splitArgs(String input) {
        Pattern p = Pattern.compile("\\s*\"(.*?)\"\\s*|(?<=^| )[^ ]*");
        Matcher m = p.matcher(input);
        ArrayList<String> result = new ArrayList<String>();
        while (m.find()) {
            result.add(m.group(1) != null ? m.group(1) : m.group());
        }
        return result.toArray(new String[result.size()]);
    }

    CommandLineReturn processInput(String input) {
        String[] args = InteractiveCommand.splitArgs(input);
        try {
            CommandLine cmdLine = this.service.parse(args, true);
            String cmdName = cmdLine.getCommand();
            if ("exit".equals(cmdName) || "quit".equals(cmdName) || "bye".equals(cmdName)) {
                return CommandLineReturn.QUIT;
            }
            this.runCommand(cmdLine);
        }
        catch (UnknownCommandException e) {
            log.error((Object)e.getMessage());
            return CommandLineReturn.FAILURE;
        }
        catch (ParseException e) {
            log.error((Object)("Command failed. " + e.getMessage()));
            log.debug((Object)e);
            return CommandLineReturn.FAILURE;
        }
        catch (EJBAccessException e) {
            log.error((Object)("Command failed. " + e.getMessage() + ". Use \"connect\" command to reconnect."));
            log.debug((Object)e);
            return CommandLineReturn.FAILURE;
        }
        catch (IllegalArgumentException e) {
            log.error((Object)("Command failed." + e.getMessage()));
            log.debug((Object)e);
            return CommandLineReturn.FAILURE;
        }
        catch (Throwable e) {
            log.error((Object)"Command failed.", e);
            return CommandLineReturn.FAILURE;
        }
        return CommandLineReturn.SUCCESS;
    }

    void runCommand(CommandLine cmdLine) throws Exception {
        CommandDescriptor cd = this.service.getCommand(cmdLine.getCommand());
        if (cd == null) {
            throw new UnknownCommandException("Unknown command: " + cmdLine.getCommand());
        }
        this.service.runCommand(cd, cmdLine);
    }

    void updatePrompt() {
        if (NuxeoClient.getInstance().isConnected()) {
            console.setDefaultPrompt(this.service.getCommandContext().getHost() + "> ");
        } else {
            console.setDefaultPrompt("|> ");
        }
    }

    void autoComplete(StringBuilder sb) {
        String prefix = sb.toString();
        if (prefix.contains(" ")) {
            return;
        }
        CommandDescriptor[] cmds = this.service.getMatchingCommands(prefix);
        if (cmds.length == 0) {
            InteractiveCommand.beep();
        } else if (cmds.length == 1) {
            sb.setLength(0);
            sb.append(cmds[0]);
            this.updatePrompt();
            System.out.print(cmds[0]);
        } else {
            for (CommandDescriptor cd : cmds) {
                System.out.println(cd.getName());
            }
            this.updatePrompt();
            System.out.print(prefix);
        }
    }

    static void beep() {
        System.out.print(7);
    }

    public void printHelp(PrintStream out) {
        out.print("A mode where commands can be run interactively. TODO");
    }

    private class UnknownCommandException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UnknownCommandException(String message) {
            super(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CommandLineReturn {
        SUCCESS,
        FAILURE,
        QUIT;

    }
}

