/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.shell.Command;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.scripting.ScriptingService;

public class ScriptCommand
implements Command {
    private static final Log log = LogFactory.getLog(ScriptCommand.class);

    public void printHelp(PrintStream out) {
    }

    public void run(CommandLine cmdLine) throws Exception {
        String file = cmdLine.getOption("file");
        if (file == null) {
            log.error((Object)"STDIN support not yet implemented. Neither stdin supported, neither any file given as input => aborting ... sorry :)");
            System.exit(10);
        }
        SimpleScriptContext ctx = new SimpleScriptContext();
        ctx.setAttribute("cmdLine", cmdLine, 100);
        this.eval(file, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String path, ScriptContext ctx) throws ScriptException {
        ScriptingService ss = null;
        try {
            ss = (ScriptingService)Framework.getLocalService(ScriptingService.class);
        }
        catch (Exception e) {
            log.error((Object)"Scripting is not enabled. To enable it copy the nuxeo-runtime-scripting bundle in app/bundles");
            System.exit(10);
        }
        ScriptEngine engine = ss.getEngineByFileName(path);
        if (engine != null) {
            Object object;
            FileReader reader = new FileReader(new File(path));
            try {
                object = engine.eval((Reader)reader, ctx);
            }
            catch (Throwable throwable) {
                try {
                    ((Reader)reader).close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ScriptException(e);
                }
            }
            ((Reader)reader).close();
            return object;
        }
        throw new ScriptException("No script engine was found for the file: " + path);
    }
}

