/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.repository;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;

public class ViewCommand
extends AbstractCommand {
    private static final Log log = LogFactory.getLog(ViewCommand.class);

    public void run(CommandLine cmdLine) throws Exception {
        Calendar cal;
        DocumentModel doc;
        String[] elements = cmdLine.getParameters();
        if (elements.length == 1) {
            Path path = new Path(elements[0]);
            try {
                doc = this.context.fetchDocument(path);
            }
            catch (Exception e) {
                log.error((Object)"Failed to retrieve the given folder", (Throwable)e);
                return;
            }
        } else {
            doc = this.context.fetchDocument();
        }
        Date ctime = (cal = (Calendar)doc.getProperty("dublincore", "created")) == null ? null : cal.getTime();
        cal = (Calendar)doc.getProperty("dublincore", "modified");
        Date mtime = cal == null ? null : cal.getTime();
        log.info((Object)"--------------------------------------------------------------------");
        log.info((Object)("UID: " + doc.getId()));
        log.info((Object)("Path: " + doc.getPathAsString()));
        log.info((Object)("Type: " + doc.getType()));
        log.info((Object)"--------------------------------------------------------------------");
        log.info((Object)("Title: " + doc.getTitle()));
        log.info((Object)("Author: " + doc.getProperty("dublincore", "creator")));
        log.info((Object)("Created: " + ctime));
        log.info((Object)("Last Modified: " + mtime));
        log.info((Object)"--------------------------------------------------------------------");
        log.info((Object)("Description: " + doc.getTitle()));
        log.info((Object)"--------------------------------------------------------------------");
    }
}

