/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.header;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import org.nuxeo.ecm.shell.header.CommandHeader;
import org.nuxeo.ecm.shell.header.CommandPattern;
import org.nuxeo.ecm.shell.header.HeaderExtractor;

public abstract class AbstractHeaderExtractor
implements HeaderExtractor {
    public static final String CRLF = System.getProperty("line.separator");

    public CommandHeader extractHeader(Reader r) throws IOException, ParseException {
        BufferedReader reader = null;
        reader = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        String line = null;
        do {
            if ((line = reader.readLine()) != null) continue;
            return null;
        } while (this.isEmpty(line = line.trim()));
        if (!this.isHeaderBoundary(line)) {
            return null;
        }
        CommandHeader header = new CommandHeader();
        do {
            if ((line = reader.readLine()) != null) continue;
            return header;
        } while (this.isEmpty(line = this.trimLine(line)));
        StringBuilder buf = new StringBuilder();
        buf.append(line);
        while (true) {
            if ((line = reader.readLine()) == null || this.isHeaderBoundary(line)) {
                header.description = buf.toString();
                return header;
            }
            if (this.isEmpty(line = this.trimLine(line))) break;
            buf.append(" ").append(line);
        }
        header.description = buf.toString();
        do {
            if ((line = reader.readLine()) != null) continue;
            return header;
        } while (this.isEmpty(line = this.trimLine(line)));
        buf.setLength(0);
        buf.append(line);
        while (true) {
            if ((line = reader.readLine()) == null || this.isHeaderBoundary(line)) {
                String input = buf.toString().trim();
                if (!this.isEmpty(input)) {
                    header.pattern = CommandPattern.parsePattern(input);
                }
                return header;
            }
            if (this.isEmpty(line = this.trimLine(line))) break;
            buf.append(line).append(" ");
        }
        String input = buf.toString().trim();
        if (!this.isEmpty(input)) {
            header.pattern = CommandPattern.parsePattern(input);
        }
        do {
            if ((line = reader.readLine()) != null) continue;
            return header;
        } while (this.isEmpty(line = this.trimLine(line)));
        buf.setLength(0);
        buf.append(line);
        while (true) {
            if ((line = reader.readLine()) == null || this.isHeaderBoundary(line)) {
                header.help = buf.toString().trim();
                return header;
            }
            line = this.trimLine(line);
            buf.append(line).append(CRLF);
        }
    }

    protected String trimLine(String line) {
        return line.trim();
    }

    protected boolean isEmpty(String line) {
        return line == null || line.length() == 0;
    }

    protected abstract boolean isHeaderBoundary(String var1);
}

