/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentTreeIterator
implements Iterator<DocumentModel> {
    private static final Log log = LogFactory.getLog(DocumentTreeIterator.class);
    protected final CoreSession session;
    protected final DocumentModel root;
    protected Iterator<DocumentModel> sequence;
    protected final Queue<Iterator<DocumentModel>> queue = new LinkedList<Iterator<DocumentModel>>();

    public DocumentTreeIterator(CoreSession session, DocumentModel root) throws ClientException {
        this(session, root, false);
    }

    public DocumentTreeIterator(CoreSession session, DocumentModel root, boolean excludeRoot) throws ClientException {
        this.root = root;
        this.session = session;
        this.sequence = excludeRoot ? session.getChildrenIterator(root.getRef()) : new OneDocSequence(root);
    }

    protected Iterator<DocumentModel> getNextNonEmptySequence() {
        Iterator<DocumentModel> seq;
        do {
            if ((seq = this.queue.poll()) != null) continue;
            return null;
        } while (!seq.hasNext());
        return seq;
    }

    @Override
    public boolean hasNext() {
        if (this.sequence == null || !this.sequence.hasNext()) {
            this.sequence = this.getNextNonEmptySequence();
            if (this.sequence == null) {
                return false;
            }
        }
        return true;
    }

    @Override
    public DocumentModel next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("no more documents to iterate over");
        }
        DocumentModel doc = this.sequence.next();
        if (doc.isFolder()) {
            try {
                this.queue.add(this.session.getChildrenIterator(doc.getRef()));
            }
            catch (ClientException e) {
                log.error((Object)e);
            }
        }
        return doc;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not yet supported");
    }

    public void reset() {
        this.sequence = new OneDocSequence(this.root);
        this.queue.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OneDocSequence
    implements Iterator<DocumentModel> {
        final DocumentModel doc;
        boolean hasNext = true;

        OneDocSequence(DocumentModel doc) {
            this.doc = doc;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public DocumentModel next() {
            if (this.doc == null) {
                throw new NoSuchElementException("no more documents to iterate over");
            }
            this.hasNext = false;
            return this.doc;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not yet supported");
        }
    }
}

