/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.adapter;

import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.adapter.DocumentAdapterDescriptor;
import org.nuxeo.ecm.core.api.adapter.PropertyFactoryDescriptor;
import org.nuxeo.ecm.core.api.adapter.SessionAdapterDescriptor;
import org.nuxeo.ecm.core.api.adapter.SessionAdapterFactory;
import org.nuxeo.ecm.core.api.model.PropertyFactory;
import org.nuxeo.ecm.core.api.model.impl.DefaultPropertyFactory;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentAdapterService
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName("service", "org.nuxeo.ecm.core.api.DocumentAdapterService");
    private static final Log log = LogFactory.getLog(DocumentAdapterService.class);
    protected Map<Class<?>, DocumentAdapterDescriptor> adapters;
    protected Map<String, PropertyFactory> factories;

    public DocumentAdapterDescriptor getAdapterDescriptor(Class<?> itf) {
        return this.adapters.get(itf);
    }

    public void registerAdapterFactory(DocumentAdapterDescriptor dae) {
        this.adapters.put(dae.getInterface(), dae);
        log.info((Object)("Registered document adapter factory " + dae));
    }

    public void unregisterAdapterFactory(Class<?> itf) {
        DocumentAdapterDescriptor dae = this.adapters.remove(itf);
        if (dae != null) {
            log.info((Object)("Unregistered document adapter factory: " + dae));
        }
    }

    public static void registerPropertyFactory(PropertyFactoryDescriptor descriptor) {
        try {
            DefaultPropertyFactory.getInstance().registerFactory(descriptor.schema, descriptor.type, (PropertyFactory)descriptor.klass.newInstance());
        }
        catch (Exception e) {
            log.error((Object)("Failed to instantiate the property type for " + descriptor.schema + ':' + descriptor.type));
        }
    }

    public static void unregisterPropertyFactory(PropertyFactoryDescriptor descriptor) {
        DefaultPropertyFactory.getInstance().unregisterFactory(descriptor.schema, descriptor.type);
    }

    public PropertyFactory getPropertyFactory(String schema, String type) {
        String key = schema != null && schema.length() > 0 ? schema + ':' + type : type;
        PropertyFactory factory = this.factories.get(key);
        if (factory == null) {
            factory = this.factories.get(type);
        }
        return factory;
    }

    public PropertyFactory getPropertyFactory(String type) {
        return this.factories.get(type);
    }

    public void activate(ComponentContext context) {
        this.factories = new Hashtable<String, PropertyFactory>();
        this.adapters = new Hashtable();
    }

    public void deactivate(ComponentContext context) {
        this.adapters.clear();
        this.adapters = null;
        this.factories.clear();
        this.factories = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("adapters")) {
            DocumentAdapterDescriptor dae = (DocumentAdapterDescriptor)contribution;
            this.registerAdapterFactory(dae);
        } else if (extensionPoint.equals("propertyFactories")) {
            PropertyFactoryDescriptor pfd = (PropertyFactoryDescriptor)contribution;
            DocumentAdapterService.registerPropertyFactory(pfd);
        } else if (extensionPoint.equals("sessionAdapters")) {
            SessionAdapterDescriptor desc = (SessionAdapterDescriptor)contribution;
            try {
                SessionAdapterFactory factory = (SessionAdapterFactory)desc.factory.newInstance();
                SessionAdapterFactory.registerAdapter(desc.itf, factory);
            }
            catch (Exception e) {
                log.error((Object)"Failed to register session adapter", (Throwable)e);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals("adapters")) {
            DocumentAdapterDescriptor dae = (DocumentAdapterDescriptor)contribution;
            this.unregisterAdapterFactory(dae.getInterface());
        } else if (extensionPoint.equals("propertyFactories")) {
            PropertyFactoryDescriptor pfd = (PropertyFactoryDescriptor)contribution;
            DocumentAdapterService.unregisterPropertyFactory(pfd);
        } else if (extensionPoint.equals("sessionAdapters")) {
            SessionAdapterDescriptor desc = (SessionAdapterDescriptor)contribution;
            SessionAdapterFactory.unregisterAdapter(desc.itf);
        }
    }
}

