/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelIterator;
import org.nuxeo.ecm.core.api.DocumentModelsChunk;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.impl.DocsQueryProviderDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentModelIteratorImpl
implements DocumentModelIterator {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DocumentModelIteratorImpl.class);
    private int chunkSize;
    private String sessionId;
    private DocumentModelsChunk dmChunk;
    private int pos = 0;
    private DocsQueryProviderDef def;
    private String type;
    private Filter filter;
    private String perm;

    public DocumentModelIteratorImpl() {
    }

    public DocumentModelIteratorImpl(CoreSession coreSession, int chunkSize, DocsQueryProviderDef def, String type, String perm, Filter filter) throws ClientException {
        this.sessionId = coreSession.getSessionId();
        this.chunkSize = chunkSize;
        this.def = def;
        this.type = type;
        this.perm = perm;
        this.filter = filter;
        this.dmChunk = coreSession.getDocsResultChunk(def, type, perm, filter, 0, chunkSize);
    }

    private void retrieveNextChunk() throws ClientException {
        CoreSession coreSession = CoreInstance.getInstance().getSession(this.sessionId);
        int offset = this.dmChunk == null ? 0 : this.dmChunk.lastIndex;
        this.dmChunk = coreSession.getDocsResultChunk(this.def, this.type, this.perm, this.filter, offset, this.chunkSize);
    }

    @Override
    public boolean hasNext() {
        return this.dmChunk.getSize() > this.pos || this.dmChunk.hasMore;
    }

    @Override
    public DocumentModel next() {
        try {
            return this.nextDocument();
        }
        catch (ClientException e) {
            log.error((Object)("Error retrieving next element: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public DocumentModel nextDocument() throws ClientException {
        DocumentModel lastDoc;
        if (this.dmChunk.getSize() > this.pos) {
            lastDoc = this.dmChunk.getItem(this.pos++);
        } else if (this.dmChunk.hasMore) {
            this.retrieveNextChunk();
            this.pos = 0;
            lastDoc = this.nextDocument();
        } else {
            throw new NoSuchElementException("no more elements");
        }
        return lastDoc;
    }

    @Override
    public void remove() {
        this.dmChunk.remove(this.pos);
    }

    @Override
    public Iterator<DocumentModel> iterator() {
        return this;
    }

    @Override
    public long size() {
        return this.dmChunk.lastIndex < this.chunkSize ? (long)this.dmChunk.getSize() : -1L;
    }
}

