/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl.blob;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.DefaultBlob;

public class StringBlob
extends DefaultBlob
implements Serializable {
    private static final long serialVersionUID = -1369527636846459436L;
    protected final String content;

    public StringBlob(String content) {
        this(content, null, "UTF-8");
    }

    public StringBlob(String content, String mimeType) {
        this(content, mimeType, "UTF-8");
    }

    public StringBlob(String content, String mimeType, String encoding) {
        this.content = content;
        this.mimeType = mimeType;
        this.encoding = encoding;
    }

    public long getLength() {
        if (this.content == null) {
            return 0L;
        }
        return this.content.length();
    }

    public InputStream getStream() throws IOException {
        if (this.content == null || this.content.length() == 0) {
            return EMPTY_INPUT_STREAM;
        }
        return new ByteArrayInputStream(this.getByteArray());
    }

    public byte[] getByteArray() throws IOException {
        if (this.content == null || this.content.length() == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        return this.content.getBytes(this.encoding == null ? "UTF-8" : this.encoding);
    }

    public String getString() throws IOException {
        if (this.content == null || this.content.length() == 0) {
            return "";
        }
        return this.content;
    }

    public Reader getReader() throws IOException {
        if (this.content == null || this.content.length() == 0) {
            return EMPTY_READER;
        }
        return new StringReader(this.content);
    }

    public boolean isPersistent() {
        return true;
    }

    public Blob persist() throws IOException {
        return this;
    }
}

