/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.impl.converter;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.AbstractBlob;
import org.nuxeo.ecm.core.api.impl.blob.ByteArrayBlob;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.api.impl.converter.ValueConverter;
import org.nuxeo.ecm.core.schema.types.TypeException;

public final class BlobConverter
extends ValueConverter {
    public static final BlobConverter INSTANCE = new BlobConverter();

    private BlobConverter() {
    }

    public Object convert(Object value) throws TypeException {
        if (value instanceof Map) {
            AbstractBlob blob;
            Map map = (Map)value;
            String encoding = (String)map.get("encoding");
            String mimeType = (String)map.get("mime-type");
            Object data = map.get("data");
            if (data.getClass() == byte[].class) {
                blob = new ByteArrayBlob((byte[])data, mimeType, encoding);
            } else if (data instanceof InputStream) {
                try {
                    blob = new FileBlob((InputStream)data, mimeType, encoding);
                }
                catch (IOException e) {
                    throw new TypeException("Failed to convert to blob " + value.getClass(), (Throwable)e);
                }
            } else {
                String str = data.toString();
                blob = new StringBlob(str, mimeType, encoding);
            }
            return blob;
        }
        if (value instanceof Blob) {
            return value;
        }
        throw new TypeException("Cannot convert value " + value.getClass() + " to type 'content'");
    }
}

