/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl.osm.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.nuxeo.ecm.core.api.model.impl.osm.util.FieldAccessor;
import org.nuxeo.ecm.core.api.model.impl.osm.util.MemberAccessor;
import org.nuxeo.ecm.core.api.model.impl.osm.util.MethodAccessor;
import org.nuxeo.ecm.core.api.model.impl.osm.util.NoSuchMemberException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectAccessorHelper {
    private ObjectAccessorHelper() {
    }

    public static Method getMethod(Class<?> containerType, String name) throws NoSuchMethodException {
        try {
            return containerType.getDeclaredMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            Class<?> superClass = containerType.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return ObjectAccessorHelper.getMethod(superClass, name);
        }
    }

    public static Field getField(Class<?> containerType, String name) throws NoSuchFieldException {
        try {
            return containerType.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = containerType.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return ObjectAccessorHelper.getField(superClass, name);
        }
    }

    public static String getGetterName(String name) {
        if (name == null) {
            return "get";
        }
        int len = name.length();
        if (len == 0) {
            return "get";
        }
        StringBuilder sb = new StringBuilder(len + 3);
        sb.append("get").append(name);
        char ch = name.charAt(0);
        ch = Character.toUpperCase(ch);
        sb.setCharAt(3, ch);
        return sb.toString();
    }

    public static String getSetterName(String name) {
        if (name == null) {
            return "set";
        }
        int len = name.length();
        if (len == 0) {
            return "set";
        }
        StringBuilder sb = new StringBuilder(len + 3);
        sb.append("set").append(name);
        char ch = name.charAt(0);
        ch = Character.toUpperCase(ch);
        sb.setCharAt(3, ch);
        return sb.toString();
    }

    public static String getPropertyName(String methodName) {
        if ((methodName.startsWith("get") || methodName.startsWith("get")) && methodName.length() > 3) {
            methodName = methodName.substring(3);
            StringBuilder sb = new StringBuilder(methodName);
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        }
        return methodName;
    }

    public static MemberAccessor getFieldAccessor(Class<?> containerType, String name) throws NoSuchFieldException {
        return new FieldAccessor(ObjectAccessorHelper.getField(containerType, name));
    }

    public static MemberAccessor getFieldAccessor(Class<?> containerType, String name, boolean isReadOnly) throws NoSuchFieldException {
        return new FieldAccessor(ObjectAccessorHelper.getField(containerType, name), isReadOnly);
    }

    public static MemberAccessor getPropertyAccessor(Class<?> containerType, String name) throws NoSuchMethodException {
        return new MethodAccessor(ObjectAccessorHelper.getMethod(containerType, ObjectAccessorHelper.getGetterName(name)), ObjectAccessorHelper.getMethod(containerType, ObjectAccessorHelper.getSetterName(name)));
    }

    public static MemberAccessor getPropertyAccessor(Class<?> containerType, String name, boolean IsReadOnly) throws NoSuchMethodException {
        String getter = ObjectAccessorHelper.getGetterName(name);
        String setter = IsReadOnly ? null : ObjectAccessorHelper.getSetterName(name);
        return ObjectAccessorHelper.getMethodAccessor(containerType, getter, setter);
    }

    public static MemberAccessor getMethodAccessor(Class<?> containerType, String getterName, String setterName) throws NoSuchMethodException {
        return new MethodAccessor(ObjectAccessorHelper.getMethod(containerType, getterName), setterName != null ? ObjectAccessorHelper.getMethod(containerType, setterName) : null);
    }

    public static MemberAccessor getMemberAccessor(Class<?> containerType, String name) throws NoSuchMemberException {
        return ObjectAccessorHelper.getMemberAccessor(containerType, name, false);
    }

    public static MemberAccessor getMemberAccessor(Class<?> containerType, String name, boolean isReadOnly) throws NoSuchMemberException {
        try {
            return ObjectAccessorHelper.getFieldAccessor(containerType, name, isReadOnly);
        }
        catch (NoSuchFieldException e) {
            try {
                return ObjectAccessorHelper.getPropertyAccessor(containerType, name, isReadOnly);
            }
            catch (NoSuchMethodException ee) {
                throw new NoSuchMemberException("No such member: " + name);
            }
        }
    }
}

