/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;

public class DataSourceHelper {
    private static final Log log = LogFactory.getLog(DataSourceHelper.class);
    public static final String PREFIX_PROPERTY = "org.nuxeo.runtime.datasource.prefix";
    public static final String DEFAULT_PREFIX = "java:comp/env/jdbc";
    protected static String prefix;

    public static void autodetectPrefix() {
        String name;
        Context ctx = DataSourceHelper.getDefaultInitCtx();
        String string = name = ctx == null ? null : ctx.getClass().getName();
        if ("org.nuxeo.common.jndi.NamingContext".equals(name)) {
            prefix = DEFAULT_PREFIX;
        } else if ("org.jnp.interfaces.NamingContext".equals(name)) {
            prefix = "java:";
        } else if ("org.apache.naming.SelectorContext".equals(name)) {
            prefix = DEFAULT_PREFIX;
        } else if ("org.mortbay.naming.local.localContextRoot".equals(name)) {
            prefix = "jdbc";
        } else if ("com.sun.enterprise.naming.impl.SerialContext".equals(name)) {
            prefix = DEFAULT_PREFIX;
        } else {
            log.error((Object)("Unknown JNDI Context class: " + name));
            prefix = DEFAULT_PREFIX;
        }
        log.info((Object)("Using JDBC JNDI prefix: " + prefix));
    }

    public static Context getDefaultInitCtx() {
        try {
            return new InitialContext(){

                public Context getDefaultInitCtx() throws NamingException {
                    return super.getDefaultInitCtx();
                }
            }.getDefaultInitCtx();
        }
        catch (NamingException e) {
            return null;
        }
    }

    public static String getDataSourceJNDIPrefix() {
        if (prefix == null) {
            if (Framework.isInitialized()) {
                String configuredPrefix = Framework.getProperty(PREFIX_PROPERTY);
                if (configuredPrefix != null) {
                    prefix = configuredPrefix;
                } else {
                    DataSourceHelper.autodetectPrefix();
                }
            } else {
                prefix = DEFAULT_PREFIX;
            }
        }
        return prefix;
    }

    public static String getDataSourceJNDIName(String partialName) {
        String targetPrefix = DataSourceHelper.getDataSourceJNDIPrefix();
        int idx = partialName.lastIndexOf("/");
        if (idx > 0) {
            partialName = partialName.substring(idx + 1);
        }
        return targetPrefix + "/" + partialName;
    }

    public static DataSource getDataSource(String partialName) throws NamingException {
        String jndiName = DataSourceHelper.getDataSourceJNDIName(partialName);
        InitialContext context = new InitialContext();
        return (DataSource)context.lookup(jndiName);
    }
}

