/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.io.DocumentTranslationMap;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.DocumentTranslationMapImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDocumentWriter
implements DocumentWriter {
    @Override
    public abstract DocumentTranslationMap write(ExportedDocument var1) throws IOException;

    @Override
    public DocumentTranslationMap write(ExportedDocument[] docs) throws IOException {
        if (docs == null || docs.length == 0) {
            return null;
        }
        String newRepo = null;
        String oldRepo = null;
        HashMap<DocumentRef, DocumentRef> newRefs = new HashMap<DocumentRef, DocumentRef>();
        for (ExportedDocument doc : docs) {
            DocumentTranslationMap newMap = this.write(doc);
            if (newMap == null) continue;
            newRefs.putAll(newMap.getDocRefMap());
            if (oldRepo == null) {
                oldRepo = newMap.getOldServerName();
            }
            if (newRepo != null) continue;
            newRepo = newMap.getNewServerName();
        }
        return new DocumentTranslationMapImpl(oldRepo, newRepo, newRefs);
    }

    @Override
    public DocumentTranslationMap write(Collection<ExportedDocument> docs) throws IOException {
        if (docs == null || docs.isEmpty()) {
            return null;
        }
        String newRepo = null;
        String oldRepo = null;
        HashMap<DocumentRef, DocumentRef> newRefs = new HashMap<DocumentRef, DocumentRef>();
        for (ExportedDocument doc : docs) {
            DocumentTranslationMap newMap = this.write(doc);
            if (newMap == null) continue;
            newRefs.putAll(newMap.getDocRefMap());
            if (oldRepo == null) {
                oldRepo = newMap.getOldServerName();
            }
            if (newRepo != null) continue;
            newRepo = newMap.getNewServerName();
        }
        return new DocumentTranslationMapImpl(oldRepo, newRepo, newRefs);
    }
}

