/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.plugins;

import java.io.IOException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.ExportedDocumentImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelReader;

public class SingleDocumentReader
extends DocumentModelReader {
    private DocumentModel doc;
    private boolean enableRepeatedReads = false;
    private boolean readDone = false;

    public SingleDocumentReader(CoreSession session, DocumentModel root) {
        super(session);
        this.doc = root;
    }

    public SingleDocumentReader(CoreSession session, DocumentRef root) throws ClientException {
        this(session, session.getDocument(root));
    }

    public void close() {
        super.close();
        this.session = null;
        this.doc = null;
    }

    public ExportedDocument read() throws IOException {
        if (this.doc != null) {
            if (this.readDone && !this.enableRepeatedReads) {
                return null;
            }
            this.readDone = true;
            return new ExportedDocumentImpl(this.doc);
        }
        this.doc = null;
        return null;
    }

    public void setEnableRepeatedReads(boolean enableRepeatedReads) {
        this.enableRepeatedReads = enableRepeatedReads;
    }
}

