/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.client.indexing.resources.document.schemas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.search.api.client.common.TypeManagerServiceDelegate;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.IndexableFieldDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultSchemaFieldDescriptorsFactory {
    private SchemaManager typeManager;

    private SchemaManager getTypeManager() {
        if (this.typeManager == null) {
            this.typeManager = TypeManagerServiceDelegate.getRemoteTypeManagerService();
        }
        return this.typeManager;
    }

    public Schema getSchemaByPrefix(String prefix) {
        return this.getTypeManager().getSchemaFromPrefix(prefix);
    }

    public Schema getSchemaByName(String name) {
        return this.getTypeManager().getSchema(name);
    }

    private List<IndexableFieldDescriptor> getFieldDescriptorsForSchema(Schema schema, Set<String> excludeFields) {
        ArrayList<IndexableFieldDescriptor> res = new ArrayList<IndexableFieldDescriptor>();
        for (Field field : schema.getFields()) {
            String fieldName = field.getName().getLocalName();
            if (excludeFields != null && excludeFields.contains(fieldName)) continue;
            Type fieldType = field.getType();
            if (fieldType.isSimpleType() || fieldType.isListType()) {
                res.addAll(this.handleField(field));
                continue;
            }
            if (fieldType.isCompositeType() || !fieldType.isComplexType()) continue;
            res.addAll(this.handleComplexField(field));
        }
        return res;
    }

    public List<IndexableFieldDescriptor> getFieldDescriptorsBySchemaName(String name, Set<String> excludeFields) {
        List<IndexableFieldDescriptor> descs = new ArrayList<IndexableFieldDescriptor>();
        Schema schema = this.getSchemaByName(name);
        if (schema != null) {
            descs = this.getFieldDescriptorsForSchema(schema, excludeFields);
        }
        return descs;
    }

    public List<IndexableFieldDescriptor> getFieldDescriptorsBySchemaPrefix(String prefix, Set<String> excludeFields) {
        List<IndexableFieldDescriptor> descs = new ArrayList<IndexableFieldDescriptor>();
        Schema schema = this.getSchemaByPrefix(prefix);
        if (schema != null) {
            descs = this.getFieldDescriptorsForSchema(schema, excludeFields);
        }
        return descs;
    }

    private Collection<IndexableFieldDescriptor> handleField(Field field) {
        String fieldName = field.getName().getLocalName();
        return this.handleFieldType(field.getType(), fieldName, false);
    }

    private List<IndexableFieldDescriptor> handleFieldType(Type type, String indexingName, boolean forceMultiple) {
        String indexingAnalyzer = "default";
        String indexingType = "keyword";
        boolean multiple = forceMultiple;
        HashMap<String, String> termVector = new HashMap<String, String>();
        if (type.isListType()) {
            multiple = true;
            if ((type = ((ListType)type).getFieldType()).isComplexType()) {
                return this.handleComplexType((ComplexType)type, indexingName + ':', multiple);
            }
        }
        boolean stored = true;
        boolean binary = false;
        if (type.getName().equals("binary")) {
            binary = true;
            indexingType = "text";
            stored = false;
        } else if (type.getName().equals("date")) {
            indexingType = "date";
        } else if (type.getName().equals("boolean")) {
            indexingType = "boolean";
        } else if (type.getName().equals("int")) {
            indexingType = "int";
        }
        ArrayList<IndexableFieldDescriptor> res = new ArrayList<IndexableFieldDescriptor>(1);
        boolean indexed = true;
        boolean sortable = true;
        res.add(new IndexableFieldDescriptor(indexingName, indexingAnalyzer, indexingType, stored, indexed, binary, multiple, sortable, null, termVector, null));
        return res;
    }

    private List<IndexableFieldDescriptor> handleComplexType(ComplexType type, String prefix, boolean multiple) {
        LinkedList<IndexableFieldDescriptor> res = new LinkedList<IndexableFieldDescriptor>();
        for (Field subField : type.getFields()) {
            res.addAll(this.handleFieldType(subField.getType(), prefix + subField.getName().getLocalName(), multiple));
        }
        return res;
    }

    private List<IndexableFieldDescriptor> handleComplexField(Field field) {
        String prefix = field.getName().getLocalName() + ':';
        return this.handleComplexType((ComplexType)field.getType(), prefix, false);
    }
}

