/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.client.indexing.resources.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.search.api.client.SearchService;
import org.nuxeo.ecm.core.search.api.client.common.SearchServiceDelegate;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.IndexableResource;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.IndexableResources;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.document.impl.DocumentBuiltinsIndexableResourceImpl;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.document.impl.DocumentIndexableResourceImpl;
import org.nuxeo.ecm.core.search.api.client.indexing.resources.impl.IndexableResourcesImpl;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.IndexableResourceConf;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.document.IndexableDocType;
import org.nuxeo.ecm.core.search.api.indexing.resources.configuration.document.IndexableDocTypeDescriptor;

public final class IndexableResourcesFactory {
    private static final Log log = LogFactory.getLog(IndexableResourcesFactory.class);
    private static final Map<String, IndexableResourceConf> resourceConfCache = new ConcurrentHashMap<String, IndexableResourceConf>();
    private static final Map<String, IndexableResourceConf> fullResourceConfCache = new ConcurrentHashMap<String, IndexableResourceConf>();
    private static final Map<String, IndexableDocType> indexableDocTypeCache = new ConcurrentHashMap<String, IndexableDocType>();
    private static final IndexableDocType NULL = new IndexableDocTypeDescriptor();

    private IndexableResourcesFactory() {
    }

    private static String computeResourcesGlobalKey(DocumentModel dm) {
        return dm.getId();
    }

    public static IndexableResources computeResourcesFor(DocumentModel dm) {
        IndexableResourceConf conf;
        if (dm == null) {
            log.error((Object)"No document model given.... Nothing to compute.");
            return null;
        }
        String sid = null;
        String docType = dm.getType();
        IndexableDocType docTypeConf = IndexableResourcesFactory.getIndexableDocType(docType);
        List<String> resourceNames = null;
        List<Object> autoSchemas = new ArrayList();
        List<Object> excludedSchemas = new ArrayList();
        if (docTypeConf != null) {
            log.debug((Object)("Found a indexable doc type configuration for docType=" + docType));
            resourceNames = docTypeConf.getResources();
            excludedSchemas = docTypeConf.getExcludedSchemas();
            if (docTypeConf.areAllSchemasIndexable()) {
                log.debug((Object)"All schemas will be scheduled to be indexed by configuration");
                String[] declaredSchemas = dm.getDeclaredSchemas();
                if (declaredSchemas == null) {
                    declaredSchemas = new String[]{};
                }
                autoSchemas = Arrays.asList(dm.getDeclaredSchemas());
            }
        }
        ArrayList<IndexableResource> resources = new ArrayList<IndexableResource>();
        if (resourceNames != null) {
            for (String resourceName : resourceNames) {
                conf = IndexableResourcesFactory.getResourceConf(resourceName, false);
                if (conf != null) {
                    log.debug((Object)("Found indexable resource configuration with name: " + resourceName));
                    if (!conf.getType().equals("schema")) continue;
                    String schemaName = conf.getName();
                    if (excludedSchemas.contains(schemaName)) {
                        log.debug((Object)("Exclude schema by configuration. schema: " + schemaName));
                        continue;
                    }
                    conf = IndexableResourcesFactory.getResourceConf(schemaName, true);
                    String[] schemas = dm.getDeclaredSchemas();
                    List<String> lschemas = Arrays.asList(schemas);
                    if (!lschemas.contains(schemaName)) continue;
                    resources.add(new DocumentIndexableResourceImpl(dm, conf, sid));
                    continue;
                }
                log.error((Object)("No registered indexing configuration for resource: " + resourceName));
            }
        } else {
            log.debug((Object)String.format("No indexable resources found for docType '%s'. Checking schema base configuration now.", docType));
        }
        for (String schemaName : autoSchemas) {
            if (resourceNames.contains(schemaName)) {
                log.debug((Object)("Discarding automatic indexing for.... schemaName=" + schemaName));
                log.debug((Object)"Because already defined as a full resource conf... check conf...");
                continue;
            }
            if (excludedSchemas.contains(schemaName)) {
                log.debug((Object)("Exclude schema by configuration. schema=" + schemaName));
                continue;
            }
            conf = IndexableResourcesFactory.getResourceConf(schemaName, true);
            resources.add(new DocumentIndexableResourceImpl(dm, conf, sid));
        }
        IndexableResourceConf builtinConf = IndexableResourcesFactory.getResourceConf("ecm", false);
        if (builtinConf != null) {
            resources.add(new DocumentBuiltinsIndexableResourceImpl(dm, builtinConf, sid));
        }
        return new IndexableResourcesImpl(IndexableResourcesFactory.computeResourcesGlobalKey(dm), resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexableDocType getIndexableDocType(String type) {
        IndexableDocType res = indexableDocTypeCache.get(type);
        if (res == null) {
            SearchService service = SearchServiceDelegate.getRemoteSearchService();
            res = service.getIndexableDocTypeFor(type);
            if (res == null) {
                res = NULL;
            }
            Map<String, IndexableDocType> map = indexableDocTypeCache;
            synchronized (map) {
                indexableDocTypeCache.put(type, res);
            }
        }
        if (res == NULL) {
            return null;
        }
        return res;
    }

    private static IndexableResourceConf getResourceConf(String resourceName, Boolean full) {
        IndexableResourceConf res = full != false ? fullResourceConfCache.get(resourceName) : resourceConfCache.get(resourceName);
        if (res == null) {
            SearchService service = SearchServiceDelegate.getRemoteSearchService();
            res = service.getIndexableResourceConfByName(resourceName, full);
            IndexableResourcesFactory.setIndexableResourceConfIntoCache(resourceName, full, res);
        }
        return res;
    }

    private static synchronized void setIndexableResourceConfIntoCache(String resourceName, Boolean full, IndexableResourceConf conf) {
        if (full.booleanValue()) {
            fullResourceConfCache.put(resourceName, conf);
        } else {
            resourceConfCache.put(resourceName, conf);
        }
    }
}

