/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.search.api.client.search.results.impl;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.search.api.client.SearchException;
import org.nuxeo.ecm.core.search.api.client.SearchService;
import org.nuxeo.ecm.core.search.api.client.common.SearchServiceDelegate;
import org.nuxeo.ecm.core.search.api.client.query.QueryException;
import org.nuxeo.ecm.core.search.api.client.query.SearchPrincipal;
import org.nuxeo.ecm.core.search.api.client.query.impl.ComposedNXQueryImpl;
import org.nuxeo.ecm.core.search.api.client.search.results.ResultItem;
import org.nuxeo.ecm.core.search.api.client.search.results.ResultSet;
import org.nuxeo.ecm.core.search.api.client.search.results.impl.DocumentModelResultItem;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetImpl
extends ArrayList<ResultItem>
implements ResultSet {
    private static final long serialVersionUID = -6376330426798015144L;
    protected final int offset;
    protected final int range;
    protected final int totalHits;
    protected final int pageHits;
    protected final String query;
    protected final SQLQuery sqlQuery;
    protected final SearchPrincipal principal;
    protected final CoreSession session;
    protected Boolean detachResultsFlag;

    public ResultSetImpl(String query, CoreSession session, int offset, int range, List<ResultItem> resultItems, int totalHits, int pageHits) {
        this.query = query;
        this.sqlQuery = null;
        this.session = session;
        this.principal = null;
        this.offset = offset;
        this.range = range;
        this.totalHits = totalHits;
        this.pageHits = pageHits;
        if (resultItems != null) {
            this.addAll(resultItems);
        }
    }

    @Deprecated
    public ResultSetImpl(SQLQuery sqlQuery, SearchPrincipal principal, int offset, int range, List<ResultItem> resultItems, int totalHits, int pageHits) {
        this.sqlQuery = sqlQuery;
        this.query = null;
        this.principal = principal;
        this.session = null;
        this.offset = offset;
        this.range = range;
        this.totalHits = totalHits;
        this.pageHits = pageHits;
        if (resultItems != null) {
            this.addAll(resultItems);
        }
    }

    public boolean detachResults() {
        if (this.detachResultsFlag == null) {
            this.detachResultsFlag = Boolean.valueOf(Framework.getProperty((String)"org.nuxeo.ecm.core.search.alwaysDetachResults", (String)"false"));
        }
        return this.detachResultsFlag;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getRange() {
        return this.range;
    }

    @Override
    public ResultSet nextPage() throws SearchException {
        if (!this.hasNextPage()) {
            return null;
        }
        return this.replay(this.offset + this.range, this.range);
    }

    @Override
    public ResultSet goToPage(int page) throws SearchException {
        int newOffset = this.range * (page - 1);
        if (newOffset >= 0 && newOffset < this.totalHits) {
            return this.replay(newOffset, this.range);
        }
        return null;
    }

    @Override
    public int getTotalHits() {
        return this.totalHits;
    }

    @Override
    public int getPageHits() {
        return this.pageHits;
    }

    @Override
    public boolean hasNextPage() {
        if (this.range == 0) {
            return false;
        }
        if (this.pageHits < this.range) {
            return false;
        }
        return this.offset + this.range < this.totalHits;
    }

    @Override
    public boolean isFirstPage() {
        return this.range == 0 ? true : this.offset < this.range;
    }

    @Override
    public ResultSet replay() throws SearchException {
        return this.replay(this.offset, this.range);
    }

    @Override
    public ResultSet replay(int offset, int range) throws SearchException {
        if (this.session != null) {
            try {
                DocumentModelList list = this.session.query(this.query, null, (long)range, (long)offset, true);
                ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>(list.size());
                for (DocumentModel doc : list) {
                    if (doc == null) continue;
                    if (this.detachResults()) {
                        try {
                            ((DocumentModelImpl)doc).detach(true);
                        }
                        catch (DocumentSecurityException e) {
                            continue;
                        }
                    }
                    resultItems.add(new DocumentModelResultItem(doc));
                }
                return new ResultSetImpl(this.query, this.session, offset, range, resultItems, (int)list.totalSize(), list.size());
            }
            catch (ClientException e1) {
                throw new SearchException("QueryException for: " + this.query);
            }
        }
        if (this.sqlQuery == null) {
            throw new SearchException("Replay is not supported");
        }
        SearchService service = SearchServiceDelegate.getRemoteSearchService();
        try {
            return service.searchQuery(new ComposedNXQueryImpl(this.sqlQuery, this.principal), offset, range);
        }
        catch (QueryException e) {
            throw new SearchException("QueryException for " + this.sqlQuery.toString());
        }
    }

    @Override
    public int getPageNumber() {
        if (this.range == 0) {
            return 1;
        }
        return (this.offset + this.range) / this.range;
    }
}

