/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.query.sql.model;

import java.util.Calendar;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.Literal;

public class DateLiteral
extends Literal {
    private static final long serialVersionUID = 279219479611055690L;
    public static final DateTimeFormatter dateParser = ISODateTimeFormat.dateParser().withLocale(Locale.getDefault());
    public static final DateTimeFormatter dateTimeParser = ISODateTimeFormat.dateOptionalTimeParser().withOffsetParsed();
    public static final DateTimeFormatter dateFormatter = ISODateTimeFormat.date();
    public static final DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime();
    public final DateTime value;
    public final boolean onlyDate;

    public DateLiteral(String value, boolean onlyDate) {
        this.onlyDate = onlyDate;
        if (onlyDate) {
            this.value = dateParser.parseDateTime(value);
        } else {
            if (value.charAt(10) == ' ') {
                char[] s = value.toCharArray();
                s[10] = 84;
                value = new String(s);
            }
            this.value = dateTimeParser.parseDateTime(value);
        }
    }

    public Calendar toCalendar() {
        return this.value.toGregorianCalendar();
    }

    public String toString() {
        if (this.onlyDate) {
            String s = dateFormatter.print((ReadableInstant)this.value);
            return new StringBuffer(s.length() + 7).append("DATE '").append(s).append("'").toString();
        }
        String s = dateTimeFormatter.print((ReadableInstant)this.value);
        return new StringBuffer(s.length() + 12).append("TIMESTAMP '").append(s).append("'").toString();
    }

    public String asString() {
        if (this.onlyDate) {
            return dateFormatter.print((ReadableInstant)this.value);
        }
        return dateTimeFormatter.print((ReadableInstant)this.value);
    }

    public void accept(IVisitor visitor) {
        visitor.visitDateLiteral(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DateLiteral) {
            return this.value.equals((Object)((DateLiteral)obj).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public static String dateTime(DateLiteral date) {
        return dateTimeFormatter.print((ReadableInstant)date.value);
    }

    public static String date(DateLiteral date) {
        return dateFormatter.print((ReadableInstant)date.value);
    }
}

