/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.query.sql.model;

import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.Literal;

public class DoubleLiteral
extends Literal {
    private static final long serialVersionUID = 5003174671214111301L;
    public final double value;

    public DoubleLiteral(double value) {
        this.value = value;
    }

    public DoubleLiteral(Double value) {
        this.value = value;
    }

    public DoubleLiteral(Float value) {
        this.value = value.floatValue();
    }

    public DoubleLiteral(String value) {
        this.value = Double.parseDouble(value);
    }

    public void accept(IVisitor visitor) {
        visitor.visitDoubleLiteral(this);
    }

    public String asString() {
        return String.valueOf(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DoubleLiteral) {
            return this.value == ((DoubleLiteral)obj).value;
        }
        return false;
    }

    public int hashCode() {
        return Double.valueOf(this.value).hashCode();
    }
}

