/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.query.sql.model;

import org.nuxeo.ecm.core.query.sql.model.Clause;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.Function;
import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.Literal;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.SelectList;

public class SelectClause
extends Clause {
    private static final long serialVersionUID = -3786932682733679665L;
    public final SelectList elements;
    public final boolean distinct;

    public SelectClause() {
        this(new SelectList(), false);
    }

    public SelectClause(boolean distinct) {
        this(new SelectList(), distinct);
    }

    public SelectClause(SelectList elements) {
        this(elements, false);
    }

    public SelectClause(SelectList elements, boolean distinct) {
        super("SELECT");
        this.elements = elements;
        this.distinct = distinct;
    }

    public void add(String alias, Operand element) {
        this.elements.add(alias, element);
    }

    public void add(Operand element) {
        this.elements.add(element.toString(), element);
    }

    public Operand get(String alias) {
        return (Operand)this.elements.get(alias);
    }

    public Reference getVariable(String alias) {
        return (Reference)this.elements.get(alias);
    }

    public Literal getLiteral(String alias) {
        return (Literal)this.elements.get(alias);
    }

    public Function getFunction(String alias) {
        return (Function)this.elements.get(alias);
    }

    public Expression getExpression(String alias) {
        return (Expression)this.elements.get(alias);
    }

    public Operand get(int i) {
        return (Operand)this.elements.get(i);
    }

    public String getAlias(int i) {
        return (String)this.elements.getKey(i);
    }

    public Reference getVariable(int i) {
        return (Reference)this.elements.get(i);
    }

    public Literal getLiteral(int i) {
        return (Literal)this.elements.get(i);
    }

    public Function getFunction(int i) {
        return (Function)this.elements.get(i);
    }

    public Expression getExpression(int i) {
        return (Expression)this.elements.get(i);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public SelectList getSelectList() {
        return this.elements;
    }

    public int count() {
        return this.elements.size();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public void accept(IVisitor visitor) {
        visitor.visitSelectClause(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SelectClause) {
            SelectClause sc = (SelectClause)obj;
            return this.elements.equals((Object)sc.elements) && this.distinct == sc.distinct;
        }
        return false;
    }

    public int hashCode() {
        int result = this.elements.hashCode();
        result = 31 * result + (this.distinct ? 1 : 0);
        return result;
    }

    public String toString() {
        return (this.distinct ? "DISTINCT " : "") + (Object)((Object)this.elements);
    }
}

