/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.management;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.management.ManagementRuntimeException;
import org.nuxeo.runtime.management.ObjectNameFactory;
import org.nuxeo.runtime.management.Resource;
import org.nuxeo.runtime.management.ResourceFactory;
import org.nuxeo.runtime.management.ResourceFactoryDescriptor;
import org.nuxeo.runtime.management.ResourcePublisher;
import org.nuxeo.runtime.management.ResourcePublisherMBean;
import org.nuxeo.runtime.management.ServerLocator;
import org.nuxeo.runtime.management.ServerLocatorService;
import org.nuxeo.runtime.management.ServiceDescriptor;
import org.nuxeo.runtime.management.ShortcutDescriptor;
import org.nuxeo.runtime.management.inspector.ModelMBeanInfoFactory;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcePublisherService
extends DefaultComponent
implements ResourcePublisher,
ResourcePublisherMBean {
    public static final String SERVICES_EXT_KEY = "services";
    public static final String FACTORIES_EXT_KEY = "factories";
    public static final String SHORTCUTS_EXT_KEY = "shortcuts";
    public static final ComponentName NAME = new ComponentName("org.nuxeo.runtime.management.ResourcePublisher");
    private static final Log log = LogFactory.getLog(ResourcePublisherService.class);
    protected final ShortcutsRegistry shortcutsRegistry = new ShortcutsRegistry();
    protected final FactoriesRegistry factoriesRegistry = new FactoriesRegistry();
    protected final ResourcesRegistry resourcesRegistry = new ResourcesRegistry();
    protected ServerLocatorService serverLocatorService;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (extensionPoint.equals(SERVICES_EXT_KEY)) {
            this.resourcesRegistry.doRegisterResource((ServiceDescriptor)contribution);
        } else if (extensionPoint.equals(FACTORIES_EXT_KEY)) {
            this.factoriesRegistry.doRegisterFactory((ResourceFactoryDescriptor)contribution);
        } else if (extensionPoint.equals(SHORTCUTS_EXT_KEY)) {
            this.shortcutsRegistry.doRegisterShortcut((ShortcutDescriptor)contribution);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (extensionPoint.equals(SERVICES_EXT_KEY)) {
            this.resourcesRegistry.doUnregisterResource((ServiceDescriptor)contribution);
        } else if (extensionPoint.equals(FACTORIES_EXT_KEY)) {
            this.factoriesRegistry.doUnregisterFactory((ResourceFactoryDescriptor)contribution);
        } else if (extensionPoint.equals(SHORTCUTS_EXT_KEY)) {
            this.shortcutsRegistry.doUnregisterShortcut((ShortcutDescriptor)contribution);
        }
    }

    public void registerResource(String shortName, String qualifiedName, Class<?> managementClass, Object instance) {
        this.resourcesRegistry.doRegisterResource(qualifiedName, managementClass, instance);
        if (shortName != null) {
            this.shortcutsRegistry.doRegisterShortcut(shortName, qualifiedName);
        }
    }

    public void unregisterResource(String shortName, String qualifiedName) {
        this.resourcesRegistry.doUnregisterResource(qualifiedName);
        if (shortName != null) {
            this.shortcutsRegistry.doUnregisterShortcut(shortName);
        }
    }

    public void registerShortcut(String shortName, String qualifiedName) {
        this.shortcutsRegistry.doRegisterShortcut(shortName, qualifiedName);
    }

    public void unregisterShortcut(String shortName) {
        this.shortcutsRegistry.doUnregisterShortcut(shortName);
    }

    @Override
    public Set<String> getShortcutsName() {
        return new HashSet<String>(this.shortcutsRegistry.registry.keySet());
    }

    @Override
    public Set<ObjectName> getResourcesName() {
        return new HashSet<ObjectName>(this.resourcesRegistry.registry.keySet());
    }

    @Override
    public ObjectName lookupName(String name) {
        if (!this.shortcutsRegistry.registry.containsKey(name)) {
            return ObjectNameFactory.getObjectName(name);
        }
        return this.shortcutsRegistry.registry.get(name);
    }

    protected void doBindResources() {
        for (Resource resource : this.resourcesRegistry.registry.values()) {
            if (resource.mbean != null) continue;
            this.resourcesRegistry.doBind(resource);
        }
    }

    @Override
    public void bindResources() {
        this.doBindResources();
    }

    protected void doUnbindResources() {
        for (Resource resource : this.resourcesRegistry.registry.values()) {
            if (resource.mbean != null) continue;
            this.resourcesRegistry.doUnbind(resource);
        }
    }

    @Override
    public void unbindResources() {
        this.doUnbindResources();
    }

    public void activate(ComponentContext context) throws Exception {
        this.serverLocatorService = (ServerLocatorService)Framework.getLocalService(ServerLocator.class);
        context.getRuntimeContext().getBundle().getBundleContext().addFrameworkListener(new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() != 1) {
                    return;
                }
                ResourcePublisherService.this.factoriesRegistry.doRegisterResources();
                ResourcePublisherService.this.doBindResources();
            }
        });
    }

    public void deactivate(ComponentContext context) {
        this.resourcesRegistry.doUnregisterResources();
    }

    public void bindResource(ObjectName name) {
        Resource resource = this.resourcesRegistry.registry.get(name);
        if (resource == null) {
            throw new IllegalArgumentException(name + " is not registered");
        }
        this.resourcesRegistry.doBind(resource);
    }

    public void unbindResource(ObjectName name) {
        Resource resource = this.resourcesRegistry.registry.get(name);
        if (resource == null) {
            throw new IllegalArgumentException(name + " is not registered");
        }
        this.resourcesRegistry.doUnbind(resource);
    }

    protected void bindForTest(MBeanServer server, ObjectName name, Object instance, Class<?> clazz) throws Exception {
        this.resourcesRegistry.doBind(server, name, instance, clazz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ResourcesRegistry {
        protected final Map<ObjectName, Resource> registry = new HashMap<ObjectName, Resource>();
        protected final ModelMBeanInfoFactory mbeanInfoFactory = new ModelMBeanInfoFactory();

        protected ResourcesRegistry() {
        }

        protected void doRegisterResource(String qualifiedName, Class<?> info, Object instance) {
            Resource resource = new Resource(ObjectNameFactory.getObjectName(qualifiedName), info, instance);
            this.doRegisterResource(resource);
        }

        protected void doRegisterResource(ServiceDescriptor descriptor) {
            Resource resource = this.doResolveServiceDescriptor(descriptor);
            this.doRegisterResource(resource);
            String shortName = descriptor.getName();
            if (!StringUtils.isEmpty((String)shortName)) {
                ResourcePublisherService.this.shortcutsRegistry.doRegisterShortcut(shortName, resource.getManagementName());
            }
        }

        protected RequiredModelMBean doBind(MBeanServer server, ObjectName name, Object instance, Class<?> clazz) throws Exception {
            RequiredModelMBean mbean = new RequiredModelMBean();
            mbean.setManagedResource(instance, "ObjectReference");
            mbean.setModelMBeanInfo(this.mbeanInfoFactory.getModelMBeanInfo(clazz));
            server.registerMBean(mbean, name);
            return mbean;
        }

        protected void doBind(Resource resource) {
            if (resource.mbean != null) {
                throw new IllegalStateException(resource + " is already bound");
            }
            MBeanServer server = ResourcePublisherService.this.serverLocatorService.lookupServer(resource.managementName.getDomain());
            try {
                resource.mbean = this.doBind(server, resource.managementName, resource.instance, resource.clazz);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("bound " + resource));
                }
            }
            catch (Exception e) {
                log.error((Object)("Cannot bind " + resource), (Throwable)e);
            }
        }

        protected void doUnbind(Resource resource) {
            if (resource.mbean == null) {
                throw new IllegalStateException(resource + " is not bound");
            }
            try {
                MBeanServer server = ResourcePublisherService.this.serverLocatorService.lookupServer(resource.managementName);
                server.unregisterMBean(resource.managementName);
            }
            catch (Exception e) {
                throw ManagementRuntimeException.wrap("Cannot unbind " + resource, e);
            }
            finally {
                resource.mbean = null;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("unbound " + resource));
                }
            }
        }

        protected void doRegisterResource(Resource resource) {
            this.registry.put(resource.getManagementName(), resource);
            if (log.isDebugEnabled()) {
                log.debug((Object)("registered " + resource.getManagementName()));
            }
        }

        protected ObjectName doResolveServiceName(ServiceDescriptor descriptor) {
            String qualifiedName = descriptor.getName();
            if (qualifiedName == null) {
                qualifiedName = ObjectNameFactory.getQualifiedName(descriptor.getResourceClass().getCanonicalName());
            }
            return ObjectNameFactory.getObjectName(qualifiedName);
        }

        protected Resource doResolveServiceDescriptor(ServiceDescriptor descriptor) {
            Class<?> resourceClass = descriptor.getResourceClass();
            Object resourceInstance = this.doResolveService(resourceClass, descriptor);
            ObjectName managementName = this.doResolveServiceName(descriptor);
            Class<?> ifaceClass = descriptor.getIfaceClass();
            Class<?> managementClass = ifaceClass != null ? ifaceClass : resourceClass;
            return new Resource(managementName, managementClass, resourceInstance);
        }

        protected <T> T doResolveService(Class<T> resourceClass, ServiceDescriptor descriptor) {
            Object service;
            try {
                service = Framework.getService(resourceClass);
            }
            catch (Exception e) {
                throw ManagementRuntimeException.wrap("Cannot locate resource using " + resourceClass, e);
            }
            if (service == null) {
                throw new ManagementRuntimeException("Cannot locate resource using " + resourceClass);
            }
            return (T)service;
        }

        protected void doUnregisterResources() {
            Iterator<Map.Entry<ObjectName, Resource>> iterator = this.registry.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ObjectName, Resource> entry = iterator.next();
                iterator.remove();
                Resource resource = entry.getValue();
                if (resource.mbean == null) continue;
                this.doUnbind(entry.getValue());
            }
        }

        protected void doUnregisterResource(ServiceDescriptor descriptor) {
            ObjectName objectName = this.doResolveServiceName(descriptor);
            this.doUnregisterResource(objectName);
            String shortName = descriptor.getName();
            if (!StringUtils.isEmpty((String)shortName)) {
                ResourcePublisherService.this.shortcutsRegistry.unregisterShortcut(shortName);
            }
        }

        protected void doUnregisterResource(String qualifiedName) {
            ObjectName objectName = ObjectNameFactory.getObjectName(qualifiedName);
            this.doUnregisterResource(objectName);
        }

        protected void doUnregisterResource(ObjectName objectName) {
            Resource resource = this.registry.remove(objectName);
            if (resource == null) {
                throw new IllegalArgumentException(objectName + " is not registered");
            }
            if (resource.mbean != null) {
                this.doUnbind(resource);
            }
        }
    }

    protected class ShortcutsRegistry {
        protected final Map<String, ObjectName> registry = new TreeMap<String, ObjectName>();

        protected ShortcutsRegistry() {
        }

        protected void doRegisterShortcut(ShortcutDescriptor descriptor) {
            this.doRegisterShortcut(descriptor.getShortName(), descriptor.getQualifiedName());
        }

        protected void doRegisterShortcut(String shortName, String qualifiedName) {
            this.registry.put(shortName, ObjectNameFactory.getObjectName(qualifiedName));
        }

        protected void doRegisterShortcut(String shortName, ObjectName qualifiedName) {
            this.registry.put(shortName, qualifiedName);
        }

        protected void doUnregisterShortcut(ShortcutDescriptor descriptor) {
            this.doUnregisterShortcut(descriptor.getShortName());
        }

        protected void doUnregisterShortcut(String name) {
            this.registry.remove(name);
        }

        public void unregisterShortcut(String name) {
            this.doUnregisterShortcut(name);
        }
    }

    protected class FactoriesRegistry {
        protected final Map<Class<? extends ResourceFactory>, ResourceFactory> registry = new HashMap<Class<? extends ResourceFactory>, ResourceFactory>();

        protected FactoriesRegistry() {
        }

        protected void doRegisterFactory(ResourceFactoryDescriptor descriptor) {
            ResourceFactory factory;
            Class<? extends ResourceFactory> factoryClass = descriptor.getFactoryClass();
            try {
                factory = factoryClass.newInstance();
            }
            catch (Exception e) {
                throw new ManagementRuntimeException("Cannot create factory " + factoryClass, e);
            }
            factory.configure(ResourcePublisherService.this, descriptor);
            this.registry.put(factoryClass, factory);
        }

        protected void doUnregisterFactory(ResourceFactoryDescriptor descriptor) {
            this.registry.remove(descriptor.getFactoryClass());
        }

        protected void doRegisterResources() {
            for (ResourceFactory factory : this.registry.values()) {
                factory.registerResources();
            }
        }
    }
}

