/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.shell.CommandLineService;
import org.nuxeo.ecm.shell.CommandOption;
import org.nuxeo.ecm.shell.Token;

public class CommandLine
extends ArrayList<Token> {
    private static final long serialVersionUID = -4057256104885351786L;
    private final Map<String, String> options;
    private final List<String> parameters;
    private final CommandLineService service;
    private String command;

    public CommandLine(CommandLineService service) {
        this.service = service;
        this.options = new HashMap<String, String>();
        this.parameters = new ArrayList<String>();
    }

    public String getCommand() {
        return this.command;
    }

    public Token addCommand(String command) {
        Token token = new Token(0, command, this.size());
        this.add(token);
        this.command = command;
        return token;
    }

    public Token setCommand(String command) {
        Token token = new Token(0, command, this.size());
        this.set(0, token);
        this.command = command;
        return token;
    }

    public boolean isInteractive() {
        return this.options.containsKey("interactive");
    }

    public Token addOption(String name) {
        Token token = new Token(1, name, this.size());
        this.add(token);
        this.options.put(name, "");
        return token;
    }

    public Token addOptionValue(String name, String value) {
        Token token = new Token(2, value, this.size());
        for (Token t : this) {
            if (t.type != 1 || !t.value.equals(name)) continue;
            token.info = t.index;
            t.info = token.index;
            break;
        }
        this.add(token);
        this.options.put(name, value);
        return token;
    }

    public Token addParameter(String str) {
        Token token = new Token(3, str, this.size(), this.parameters.size());
        this.add(token);
        this.parameters.add(str);
        return token;
    }

    public Token getToken(int offset) {
        return (Token)this.get(offset);
    }

    public boolean isOptionSet(String name) {
        return this.getOption(name) != null;
    }

    public String getOption(String name) {
        CommandOption opt;
        String value = this.options.get(name);
        if (value == null && (opt = this.service.getCommandOption(name)) != null) {
            return opt.getDefaultValue();
        }
        return value;
    }

    public String[] getParameters() {
        return this.parameters.toArray(new String[this.parameters.size()]);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Command Line: ").append(this.command).append("\r\n");
        builder.append(this.options.toString());
        builder.append("\r\n").append(this.parameters.toString());
        return builder.toString();
    }
}

