/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.io;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.repository.RepositoryInstance;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentTreeReader;
import org.nuxeo.ecm.core.io.impl.plugins.XMLDirectoryWriter;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;

public class ExportCommand
extends AbstractCommand {
    private static final Log log = LogFactory.getLog(ExportCommand.class);
    private RepositoryInstance repository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(CommandLine cmdLine) throws Exception {
        String[] elements = cmdLine.getParameters();
        if (elements.length != 2) {
            log.error((Object)"Usage : export src dest");
            return;
        }
        String path = elements[0];
        File file = new File(elements[1]);
        this.repository = this.context.getRepositoryInstance();
        try {
            this.exportTree(path, file);
        }
        finally {
            this.repository.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exportTree(String fromPath, File file) throws Exception {
        if (fromPath == null || file == null) {
            log.error((Object)"Command Syntax Error. See help page");
            return;
        }
        DocumentTreeReader reader = null;
        XMLDirectoryWriter writer = null;
        try {
            DocumentModel root = this.repository.getDocument((DocumentRef)new PathRef(fromPath));
            reader = new DocumentTreeReader((CoreSession)this.repository, root, false);
            writer = new XMLDirectoryWriter(file);
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            pipe.setReader((DocumentReader)reader);
            pipe.setWriter((DocumentWriter)writer);
            pipe.run();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }
}

