/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.shell.commands.repository;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.api.repository.RepositoryInstance;
import org.nuxeo.ecm.core.client.NuxeoClient;
import org.nuxeo.ecm.core.search.api.client.common.SearchServiceDelegate;
import org.nuxeo.ecm.shell.CommandLine;
import org.nuxeo.ecm.shell.commands.repository.AbstractCommand;
import org.nuxeo.runtime.services.streaming.FileSource;
import org.nuxeo.runtime.services.streaming.StreamSource;

public class FSImportCommand
extends AbstractCommand {
    private static final int MAX_IDX_BATCH_SIZE = 50;
    protected static final Log log = LogFactory.getLog(FSImportCommand.class);
    private static final String NO_JMS_OPTION = "no-jms";
    private static final String NO_SYNC_IDX_OPTION = "no-sync-indexing";
    private static final String ONLY_CORE = "only-core";
    private static final String FULL_INDEXING = "full-indexing";
    private static final long RECYCLE_CORE_SESSION_INTERVAL = 100L;

    private void printHelp() {
        System.out.println("");
        System.out.println("Syntax: fsimport local_file_path [remote_path] [batch_size] [option]");
        System.out.println(" local_file_path : path to a local directory containing files to import");
        System.out.println(" remote_path (optionnal, default=/): reprository path where documents must be created");
        System.out.println(" batch_size (optionnal, default=50): size of import batch");
        System.out.println(" option : ");
        System.out.println("          no-jms : desactivate JMS events on document creation");
        System.out.println("          only-core : desactivate JMS events on document creation and synchronous indexing");
        System.out.println("          no-sync-indexing : desactivate synchronous indexing");
        System.out.println("          full-indexing : synchronous and asynchronous indexing activated");
        System.out.println("           if option is not set, no indexing is done");
    }

    @Override
    public void run(CommandLine cmdLine) throws Exception {
        DocumentModel parent;
        String[] elements = cmdLine.getParameters();
        if (elements.length == 0) {
            log.error((Object)"SYNTAX ERROR: the fsimport command must take at least one argument: fsimport local_file_path [remote_path] [batch_size] ");
            this.printHelp();
            return;
        }
        File localFile = new File(elements[0]);
        if ("help".equals(elements[0])) {
            this.printHelp();
            return;
        }
        if (elements.length >= 2) {
            Path path = new Path(elements[1]);
            try {
                parent = this.context.fetchDocument(path);
            }
            catch (Exception e) {
                log.error((Object)"Failed to retrieve the given folder", (Throwable)e);
                return;
            }
        } else {
            parent = this.context.fetchDocument();
        }
        Integer batchSize = 50;
        if (elements.length >= 3) {
            try {
                batchSize = Integer.parseInt(elements[2]);
            }
            catch (Throwable t) {
                batchSize = 10;
                log.error((Object)("Failed to parse batch size, using default batchSize=" + batchSize), t);
            }
        }
        String optim = ONLY_CORE;
        if (elements.length >= 4) {
            optim = elements[3];
        }
        Boolean blockJMS = false;
        Boolean blockSyncIndexing = false;
        if (ONLY_CORE.equals(optim)) {
            blockJMS = true;
            blockSyncIndexing = true;
            log.info((Object)"JMS and Sync indexing will be desactivated during this import");
        } else if (NO_SYNC_IDX_OPTION.equals(optim)) {
            blockJMS = false;
            blockSyncIndexing = true;
            log.info((Object)"Sync indexing will be desactivated for during import");
        } else if (NO_JMS_OPTION.equals(optim)) {
            blockJMS = true;
            blockSyncIndexing = false;
            log.info((Object)"JMS forwarding will be desactivated for during import");
        } else {
            log.info((Object)"Sync indexing abd JMS forwarding will be activated for during import");
        }
        RepositoryInstance repo = this.context.getRepositoryInstance();
        ImportTask task = new ImportTask((CoreSession)repo, batchSize, blockJMS, blockSyncIndexing);
        task.setInputFile(localFile);
        task.setTargetFolder(parent);
        log.info((Object)"Starting import task");
        task.run();
    }

    protected ImportTask getTask() {
        return null;
    }

    protected class ImportTask
    implements Runnable {
        boolean isRunning = false;
        long t0;
        long uploadedFiles;
        long commits = 0L;
        long uploadedKO;
        int batchSize;
        int indexingBatchSize;
        CoreSession session;
        DocumentModel rootDoc;
        File rootFile;
        Boolean blockJMS = false;
        Boolean blockSyncIndexing = false;

        protected ImportTask(CoreSession session, int batchSize, Boolean blockJMS, Boolean blockSyncIndexing) {
            this(session, batchSize);
            this.blockJMS = blockJMS;
            this.blockSyncIndexing = blockSyncIndexing;
        }

        protected ImportTask(CoreSession session, int batchSize) {
            if (session == null) {
                // empty if block
            }
            this.session = session;
            this.batchSize = batchSize;
            this.indexingBatchSize = batchSize;
            this.uploadedFiles = 0L;
        }

        protected ImportTask(File rootFile, DocumentModel rootDoc) {
            this(null, 50);
        }

        protected ImportTask(CoreSession session, File rootFile, DocumentModel rootDoc) {
            this(session, 50);
        }

        protected void commit() throws Exception {
            ++this.uploadedFiles;
            long tcomit = System.currentTimeMillis();
            if (this.uploadedFiles % 10L == 0L) {
                log.info((Object)(this.uploadedFiles + " doc created ..."));
            }
            if (this.uploadedFiles % (long)this.batchSize == 0L) {
                log.debug((Object)("Comiting Core Session after " + this.uploadedFiles + " files"));
                log.debug((Object)((double)this.uploadedFiles / ((double)(tcomit - this.t0) / 1000.0) + " doc/s"));
                log.debug((Object)((double)this.uploadedKO / ((double)(tcomit - this.t0) / 1000.0) + " KB/s"));
                this.session.save();
                ++this.commits;
                if (this.commits % 100L == 0L) {
                    this.recyleCoreSession();
                }
            }
        }

        protected void recyleCoreSession() throws Exception {
            log.debug((Object)"Recycling core session ");
            String repoName = this.session.getRepositoryName();
            this.session.disconnect();
            this.session = NuxeoClient.getInstance().openRepository(repoName);
        }

        public DocumentModel createDirectory(DocumentModel parent, File file) throws Exception {
            String name = this.getValidNameFromFileName(file.getName());
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("BLOCK_JMS_PRODUCING", true);
            String docType = "Folder";
            DocumentModel doc = this.session.createDocumentModel(docType, options);
            doc.setPathInfo(parent.getPathAsString(), name);
            doc.setProperty("dublincore", "title", (Object)file.getName());
            if (this.blockJMS.booleanValue()) {
                doc.putContextData("BLOCK_JMS_PRODUCING", (Serializable)Boolean.valueOf(true));
            }
            if (this.blockSyncIndexing.booleanValue()) {
                doc.putContextData("BLOCK_SYNC_INDEXING", (Serializable)Boolean.valueOf(true));
            }
            log.debug((Object)("Creating Folder " + name + " at " + parent.getPathAsString()));
            doc = this.session.createDocument(doc);
            this.commit();
            return doc;
        }

        public DocumentModel createFile(DocumentModel parent, File file) throws Exception {
            if (!file.exists()) {
                log.warn((Object)("non readable file: " + file.getName()));
                return null;
            }
            String mimeType = this.getMimeType(file);
            String docType = "File";
            String name = this.getValidNameFromFileName(file.getName());
            String fileName = file.getName();
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("BLOCK_JMS_PRODUCING", true);
            DocumentModel doc = this.session.createDocumentModel(docType, options);
            if (this.blockJMS.booleanValue()) {
                doc.putContextData("BLOCK_JMS_PRODUCING", (Serializable)Boolean.valueOf(true));
            }
            if (this.blockSyncIndexing.booleanValue()) {
                doc.putContextData("BLOCK_SYNC_INDEXING", (Serializable)Boolean.valueOf(true));
            }
            doc.setPathInfo(parent.getPathAsString(), name);
            doc.setProperty("dublincore", "title", (Object)file.getName());
            doc.setProperty("file", "filename", (Object)fileName);
            FileSource src = new FileSource(file);
            StreamingBlob streamingBlob = new StreamingBlob((StreamSource)src, mimeType);
            doc.setProperty("file", "content", (Object)streamingBlob);
            long kbSize = file.length() / 1024L;
            log.debug((Object)("Creating doc " + name + " at " + parent.getPathAsString() + " with file " + fileName + " of size " + kbSize + "KB"));
            doc = this.session.createDocument(doc);
            this.uploadedKO += kbSize;
            this.commit();
            return doc;
        }

        protected void upload(DocumentModel parent, File file) throws Exception {
            if (file.isDirectory()) {
                DocumentModel folder = this.createDirectory(parent, file);
                File[] files = file.listFiles();
                if (files.length > 0) {
                    ImportTask task = FSImportCommand.this.getTask();
                    if (task != null) {
                        task.run();
                    } else {
                        for (File f : file.listFiles()) {
                            this.upload(folder, f);
                        }
                    }
                }
            } else {
                this.createFile(parent, file);
            }
        }

        public void setInputFile(File rootFile) {
            this.rootFile = rootFile;
        }

        public void setTargetFolder(DocumentModel rootDoc) {
            this.rootDoc = rootDoc;
        }

        protected String getMimeType(File file) {
            String fileName = file.getName();
            if (fileName == null) {
                return "application/octet-stream";
            }
            if (fileName.endsWith(".doc")) {
                return "application/msword";
            }
            if (fileName.endsWith(".xls")) {
                return "application/vnd.ms-excel";
            }
            if (fileName.endsWith(".ppt")) {
                return "application/vnd.ms-powerpoint";
            }
            if (fileName.endsWith(".txt")) {
                return "text/plain";
            }
            if (fileName.endsWith(".html")) {
                return "text/html";
            }
            if (fileName.endsWith(".xml")) {
                return "text/xml";
            }
            if (fileName.endsWith(".jpg")) {
                return "image/jpeg";
            }
            if (fileName.endsWith(".jpeg")) {
                return "image/jpeg";
            }
            if (fileName.endsWith(".gif")) {
                return "image/gif";
            }
            if (fileName.endsWith(".odt")) {
                return "application/vnd.oasis.opendocument.text";
            }
            if (fileName.endsWith(".zip")) {
                return "application/zip";
            }
            return "application/octet-stream";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRunning() {
            ImportTask importTask = this;
            synchronized (importTask) {
                return this.isRunning;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            this.t0 = System.currentTimeMillis();
            ImportTask importTask = this;
            synchronized (importTask) {
                if (this.isRunning) {
                    throw new IllegalStateException("Task already running");
                }
                this.isRunning = true;
                if (this.rootDoc == null || this.rootFile == null) {
                    this.isRunning = false;
                    throw new IllegalArgumentException("target folder and source file must be specified");
                }
            }
            try {
                Object searchService = SearchServiceDelegate.getRemoteSearchService();
                Integer oldBatchSize = null;
                long initialCompletedIndexingTasks = 0L;
                if (searchService != null) {
                    oldBatchSize = searchService.getIndexingDocBatchSize();
                    this.indexingBatchSize = this.batchSize > 50 ? 50 : this.batchSize;
                    searchService.setIndexingDocBatchSize(this.indexingBatchSize);
                    log.info((Object)("Setting indexing batch size to " + searchService.getIndexingDocBatchSize()));
                    log.info((Object)("Indexing thread pool size = " + searchService.getNumberOfIndexingThreads()));
                    initialCompletedIndexingTasks = searchService.getTotalCompletedIndexingTasks();
                    log.debug((Object)("Already completed indexing tasks= " + initialCompletedIndexingTasks));
                    if (searchService.getActiveIndexingTasks() > 0) {
                        log.warn((Object)"Indexing queue is not empty ");
                    }
                }
                if (this.blockJMS.booleanValue()) {
                    log.info((Object)"JMS event production is disabled ");
                }
                if (this.blockSyncIndexing.booleanValue()) {
                    log.info((Object)"Synchronous indexing is disabled");
                }
                this.upload(this.rootDoc, this.rootFile);
                this.session.save();
                log.info((Object)"doc upload terminated");
                if (searchService != null) {
                    log.info((Object)"sync indexing terminated");
                }
                long t1 = System.currentTimeMillis();
                log.info((Object)(this.uploadedFiles + " doc created in " + (t1 - this.t0) + "ms"));
                log.info((Object)((double)this.uploadedFiles / ((double)(t1 - this.t0) / 1000.0) + " doc/s"));
                log.info((Object)((double)this.uploadedKO / ((double)(t1 - this.t0) / 1000.0) + " KB/s"));
                if (searchService != null) {
                    log.info((Object)"waiting for asynchronous indexing to finish");
                    while (searchService.getActiveIndexingTasks() > 0) {
                        Thread.sleep(2500L);
                        long completedTasks = searchService.getTotalCompletedIndexingTasks();
                        log.debug((Object)("completed indexing tasks= " + completedTasks));
                        long nbIndexedDocs = searchService.getTotalCompletedIndexingTasks() - initialCompletedIndexingTasks;
                        long indexToGo = this.uploadedFiles - nbIndexedDocs;
                        if (indexToGo > 0L) {
                            log.info((Object)(nbIndexedDocs + " doc indexed (" + indexToGo + " to go ... )"));
                            continue;
                        }
                        log.info((Object)(nbIndexedDocs + " doc indexed (processing additionnal reindex JMS events)"));
                    }
                    long t2 = System.currentTimeMillis();
                    log.info((Object)"Async indexing completed");
                    log.info((Object)(this.uploadedFiles + " doc indexed in " + (t2 - this.t0) + "ms"));
                    log.info((Object)((double)this.uploadedFiles / (double)((t2 - this.t0) / 1000L) + " doc/s"));
                    searchService.setIndexingDocBatchSize(oldBatchSize.intValue());
                }
            }
            catch (Exception e) {
                log.error((Object)"Error during import", (Throwable)e);
            }
            finally {
                ImportTask importTask2 = this;
                synchronized (importTask2) {
                    this.isRunning = false;
                }
            }
        }

        protected String getValidNameFromFileName(String fileName) {
            String name = IdUtils.generateId((String)fileName, (String)"-", (boolean)true, (int)100);
            name = name.replace("'", "");
            name = name.replace("(", "");
            name = name.replace(")", "");
            name = name.replace("+", "");
            return name;
        }

        public void dispose() {
            try {
                CoreInstance.getInstance().close(this.session);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }
}

